/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.reward.cost.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.common.local.model.Result;
import com.biz.crm.cps.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.common.sdk.vo.LoginUserDetails;
import com.biz.crm.cps.business.reward.cost.local.entity.CostTerminalEntity;
import com.biz.crm.cps.business.reward.cost.local.service.CostTerminalService;
import com.biz.crm.cps.business.reward.cost.sdk.dto.CostTerminalDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u7ec8\u7aef\u8d39\u7528"})
@RestController
@RequestMapping(value={"/v1/cost/terminal"})
public class CostTerminalController {
    private static final Logger log = LoggerFactory.getLogger(CostTerminalController.class);
    @Autowired
    private CostTerminalService costTerminalService;
    @Autowired
    private LoginUserService loginUserService;

    @ApiOperation(value="\u591a\u6761\u4ef6\u5206\u9875\u67e5\u8be2")
    @GetMapping(value={"findByConditions"})
    public Result<Page<CostTerminalEntity>> findByConditions(@ApiParam(name="costTerminalDto", value="\u7ec8\u7aef\u5206\u9875Dto") CostTerminalDto costTerminalDto, @PageableDefault(value=50) Pageable pageable) {
        try {
            Page<CostTerminalEntity> result = this.costTerminalService.findByConditions(costTerminalDto, pageable);
            return Result.ok(result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u7f16\u7801\u67e5\u8be2")
    @GetMapping(value={"findByTerminalCode"})
    public Result<CostTerminalEntity> findByTerminalCode(@RequestParam(value="") @ApiParam(name="terminalCode", value="\u7ec8\u7aef\u7f16\u7801") String terminalCode) {
        try {
            CostTerminalEntity result = this.costTerminalService.findByTerminalCode(terminalCode);
            return Result.ok((Object)((Object)result));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u5f53\u524d\u767b\u9646\u4eba\u7f16\u7801\u67e5\u8be2")
    @GetMapping(value={"findByCurrentUser"})
    public Result<CostTerminalEntity> findByCurrentUser() {
        try {
            LoginUserDetails userDetails = this.loginUserService.getLoginUser();
            CostTerminalEntity result = this.costTerminalService.findByTerminalCode(userDetails.getConsumerCode());
            return Result.ok((Object)((Object)result));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

