/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.reward.cost.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.common.local.model.Result;
import com.biz.crm.cps.business.reward.cost.local.entity.CostTerminalDetailEntity;
import com.biz.crm.cps.business.reward.cost.local.service.CostTerminalBillService;
import com.biz.crm.cps.business.reward.cost.sdk.dto.ApproveDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u7ec8\u7aef\u8d39\u7528\u4e0a\u8d26"})
@RestController
@RequestMapping(value={"/v1/cost/terminalBill"})
public class CostTerminalBillController {
    private static final Logger log = LoggerFactory.getLogger(CostTerminalBillController.class);
    @Autowired
    private CostTerminalBillService costTerminalBillService;

    @ApiOperation(value="\u521b\u5efa\u4e0a\u8d26")
    @PostMapping(value={""})
    public Result<CostTerminalDetailEntity> create(@RequestBody @ApiParam(name="terminalBillEntity", value="\u4e0a\u8d26") CostTerminalDetailEntity terminalBillEntity) {
        try {
            CostTerminalDetailEntity current = this.costTerminalBillService.create(terminalBillEntity);
            return Result.ok((Object)((Object)current));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6279\u91cf\u5ba1\u6279")
    @PostMapping(value={"approve"})
    public Result<?> approve(@RequestBody @ApiParam(name="approveDto") ApproveDto approveDto) {
        try {
            this.costTerminalBillService.approve(approveDto.getIds(), approveDto.getReviewStatus(), approveDto.getDealerCode());
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u8d39\u7528\u5ba1\u6838-\u5f85\u5ba1\u6838\u9875\u9762")
    @GetMapping(value={"findByDealerCode"})
    public Result<Page<CostTerminalDetailEntity>> findByDealerCode(@RequestParam(value="dealerCode") @ApiParam(name="dealerCode", value="\u7ecf\u9500\u5546\u7f16\u7801") String dealerCode, @RequestParam(value="reviewStatus") @ApiParam(name="reviewStatus", value="\u5ba1\u6838\u72b6\u6001(1.\u5f85\u5ba1\u68382.\u901a\u8fc73.\u9a73\u56de)") Integer reviewStatus, @PageableDefault(value=50) Pageable pageable) {
        try {
            Page<CostTerminalDetailEntity> result = this.costTerminalBillService.findByDealerCode(dealerCode, reviewStatus, pageable);
            return Result.ok(result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

