/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.reward.cost.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.reward.cost.local.entity.CostDealerEntity;
import com.biz.crm.cps.business.reward.cost.local.repository.CostDealerRepository;
import com.biz.crm.cps.business.reward.cost.local.service.CostDealerService;
import com.biz.crm.cps.business.reward.cost.sdk.dto.CostDealerDto;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CostDealerServiceImpl
implements CostDealerService {
    private static final Logger log = LoggerFactory.getLogger(CostDealerServiceImpl.class);
    @Autowired
    private CostDealerRepository costDealerRepository;

    @Override
    public Page<CostDealerEntity> findByConditions(CostDealerDto costDealerDto, Pageable pageable) {
        if (costDealerDto == null) {
            return new Page();
        }
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        costDealerDto.setTenantCode(TenantUtils.getTenantCode());
        return this.costDealerRepository.findByConditions(costDealerDto, pageable);
    }

    @Override
    public CostDealerEntity findByDealerCode(String dealerCode) {
        if (StringUtils.isBlank((CharSequence)dealerCode)) {
            return null;
        }
        return this.costDealerRepository.findByDealerCode(dealerCode);
    }

    @Override
    @Transactional
    public CostDealerEntity update(CostDealerEntity dealer) {
        this.updateValidate(dealer);
        this.costDealerRepository.saveOrUpdate((Object)dealer);
        return dealer;
    }

    private void updateValidate(CostDealerEntity dealer) {
        Validate.notNull((Object)((Object)dealer), (String)"\u4fee\u6539\u65f6\uff0c\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dealer.getId(), (String)"\u4fee\u6539\u65f6\uff0c\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dealer.getDealerCode(), (String)"\u4fee\u6539\u65f6\uff0c\u7ecf\u9500\u5546\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dealer.getDealerName(), (String)"\u4fee\u6539\u65f6\uff0c\u7ecf\u9500\u5546\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        CostDealerEntity byDealerCode = this.findByDealerCode(dealer.getDealerCode());
        Validate.isTrue((byDealerCode != null ? 1 : 0) != 0, (String)"\u4fee\u6539\u65f6\uff0c\u672a\u627e\u5230\u5bf9\u5e94\u6570\u636e\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        Validate.isTrue((dealer.getDealerCode() == null || dealer.getDealerCode().length() < 128 ? 1 : 0) != 0, (String)"\u7ecf\u9500\u5546\u7f16\u7801,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((dealer.getDealerName() == null || dealer.getDealerCode().length() < 255 ? 1 : 0) != 0, (String)"\u7ecf\u9500\u5546\u7f16\u7801,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((dealer.getChannel() == null || dealer.getChannel().length() < 64 ? 1 : 0) != 0, (String)"\u6e20\u9053\u7f16\u7801,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((dealer.getOrgCode() == null || dealer.getOrgCode().length() < 128 ? 1 : 0) != 0, (String)"\u6240\u5c5e\u7ec4\u7ec7\u7f16\u7801,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((dealer.getOrgName() == null || dealer.getOrgName().length() < 255 ? 1 : 0) != 0, (String)"\u6240\u5c5e\u7ec4\u7ec7\u540d\u79f0,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    @Override
    @Transactional
    public CostDealerEntity create(CostDealerEntity dealer) {
        this.createValidate(dealer);
        this.costDealerRepository.save((Object)dealer);
        return dealer;
    }

    @Override
    public CostDealerEntity findTop1ByDealerCode(String dealerCode) {
        if (StringUtils.isBlank((CharSequence)dealerCode)) {
            return null;
        }
        return this.costDealerRepository.findTop1ByDealerCode(dealerCode);
    }

    private void createValidate(CostDealerEntity dealer) {
        Validate.notNull((Object)((Object)dealer), (String)"\u521b\u5efa\u65f6\uff0c\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dealer.getDealerCode(), (String)"\u521b\u5efa\u65f6\uff0c\u7ecf\u9500\u5546\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dealer.getDealerName(), (String)"\u521b\u5efa\u65f6\uff0c\u7ecf\u9500\u5546\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        CostDealerEntity byDealerCode = this.findByDealerCode(dealer.getDealerCode());
        Validate.isTrue((byDealerCode == null ? 1 : 0) != 0, (String)"\u521b\u5efa\u65f6\uff0c\u6570\u636e\u5df2\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        Validate.isTrue((dealer.getDealerCode() == null || dealer.getDealerCode().length() < 128 ? 1 : 0) != 0, (String)"\u7ecf\u9500\u5546\u7f16\u7801,\u5728\u8fdb\u884c\u521b\u5efa\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((dealer.getDealerName() == null || dealer.getDealerCode().length() < 255 ? 1 : 0) != 0, (String)"\u7ecf\u9500\u5546\u7f16\u7801,\u5728\u8fdb\u884c\u521b\u5efa\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((dealer.getChannel() == null || dealer.getChannel().length() < 64 ? 1 : 0) != 0, (String)"\u6e20\u9053\u7f16\u7801,\u5728\u8fdb\u884c\u521b\u5efa\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((dealer.getOrgCode() == null || dealer.getOrgCode().length() < 128 ? 1 : 0) != 0, (String)"\u6240\u5c5e\u7ec4\u7ec7\u7f16\u7801,\u5728\u8fdb\u884c\u521b\u5efa\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((dealer.getOrgName() == null || dealer.getOrgName().length() < 255 ? 1 : 0) != 0, (String)"\u6240\u5c5e\u7ec4\u7ec7\u540d\u79f0,\u5728\u8fdb\u884c\u521b\u5efa\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }
}

