/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.reward.cost.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.agreement.sdk.dto.LoginUserAgreementDto;
import com.biz.crm.cps.business.agreement.sdk.service.AgreementVoService;
import com.biz.crm.cps.business.agreement.sdk.vo.AgreementVo;
import com.biz.crm.cps.business.participator.sdk.common.enums.ParticipatorTypeEnum;
import com.biz.crm.cps.business.reward.cost.local.repository.CostDetailVoRepository;
import com.biz.crm.cps.business.reward.cost.local.service.CostDetailVoService;
import com.biz.crm.cps.business.reward.cost.sdk.vo.CostDetailVo;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CostDetailVoServiceImpl
implements CostDetailVoService {
    private static final Logger log = LoggerFactory.getLogger(CostDetailVoServiceImpl.class);
    @Autowired
    private CostDetailVoRepository costDetailVoRepository;
    @Autowired
    private AgreementVoService agreementVoService;

    @Override
    public Page<CostDetailVo> findByConditions(String participatorCode, String participatorType, String yearAndMonth, Integer type, Pageable pageable) {
        List agreements;
        LoginUserAgreementDto dto;
        if (StringUtils.isBlank((CharSequence)participatorCode) || StringUtils.isBlank((CharSequence)participatorType) || StringUtils.isBlank((CharSequence)yearAndMonth)) {
            return new Page();
        }
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        Page<CostDetailVo> page = new Page<CostDetailVo>();
        if (ParticipatorTypeEnum.DEALER.getDictCode().equals(participatorType) && (page = this.costDetailVoRepository.findByParticipatorCodeAndTimeAndTypeAndDealer(participatorCode, yearAndMonth, type, pageable)) != null && !CollectionUtils.isEmpty((Collection)page.getRecords())) {
            for (CostDetailVo vo : page.getRecords()) {
                if (vo.getCostType() == 1) {
                    dto = new LoginUserAgreementDto();
                    dto.setTerminalCode(participatorCode);
                    dto.setTemplateCodes((List)Lists.newArrayList((Object[])new String[]{vo.getTemplateCode()}));
                    agreements = this.agreementVoService.findByConditions(dto);
                    if (!CollectionUtils.isEmpty((Collection)agreements)) {
                        vo.setAgreementCode(((AgreementVo)agreements.get(0)).getAgreementCode());
                        vo.setAgreementName(((AgreementVo)agreements.get(0)).getAgreementName());
                    }
                }
                if (vo.getCostType() == 2 && vo.getBillType() == 1) {
                    vo.setAgreementName("\u54c1\u724c\u5546\u4e0a\u8d26\u8d39\u7528(\u8d27\u8865\u4e0a\u8d26)");
                }
                if (vo.getCostType() != 2 || vo.getBillType() != 2) continue;
                vo.setAgreementName("\u54c1\u724c\u5546\u4e0a\u8d26\u8d39\u7528(\u6298\u6263\u4e0a\u8d26)");
            }
        }
        if (ParticipatorTypeEnum.TERMINAL.getDictCode().equals(participatorType) && (page = this.costDetailVoRepository.findByParticipatorCodeAndTimeAndTypeAndTerminal(participatorCode, yearAndMonth, type, pageable)) != null && !CollectionUtils.isEmpty((Collection)page.getRecords())) {
            for (CostDetailVo vo : page.getRecords()) {
                if (vo.getCostType() == 1) {
                    dto = new LoginUserAgreementDto();
                    dto.setTerminalCode(participatorCode);
                    dto.setTemplateCodes((List)Lists.newArrayList((Object[])new String[]{vo.getTemplateCode()}));
                    agreements = this.agreementVoService.findByConditions(dto);
                    if (!CollectionUtils.isEmpty((Collection)agreements)) {
                        vo.setAgreementCode(((AgreementVo)agreements.get(0)).getAgreementCode());
                        vo.setAgreementName(((AgreementVo)agreements.get(0)).getAgreementName());
                    }
                }
                if (vo.getCostType() != 2) continue;
                vo.setAgreementName("\u8d39\u7528\u6838\u9500");
            }
        }
        return page;
    }
}

