/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.reward.cost.local.service.internal;

import com.alibaba.fastjson.JSONArray;
import com.biz.crm.cps.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.cps.business.reward.cost.local.entity.CostDealerDetailEntity;
import com.biz.crm.cps.business.reward.cost.local.repository.CostDealerDetailRepository;
import com.biz.crm.cps.business.reward.cost.sdk.common.enums.SendTpmStatusEnum;
import com.biz.crm.cps.business.reward.cost.sdk.service.TPMCostRewardRecordService;
import com.biz.crm.cps.external.feign.service.CpsTpmFeign;
import com.biz.crm.nebular.tpm.actcenter.FeeBudgetChangeVo;
import com.biz.crm.util.Result;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class TPMCostRewardRecordServiceImpl
implements TPMCostRewardRecordService {
    private static final Logger log = LoggerFactory.getLogger(TPMCostRewardRecordServiceImpl.class);
    @Autowired
    private CostDealerDetailRepository costDealerDetailRepository;
    @Autowired
    private GenerateCodeService generateCodeService;
    @Autowired
    private CpsTpmFeign cpsTpmFeign;

    public boolean tpmCostDeduction() {
        Hashtable map = new Hashtable();
        List<CostDealerDetailEntity> list = this.costDealerDetailRepository.findByDate((Date)map.get("startTime"), (Date)map.get("endTime"));
        log.info("tpm\u8d39\u7528\u6263\u51cf:{}", (Object)JSONArray.toJSONString(list));
        if (!CollectionUtils.isEmpty(list)) {
            ArrayList entityList = Lists.newArrayList();
            BigDecimal total = new BigDecimal(0);
            String tpmBusiness = (String)this.generateCodeService.generateCode("CPS_budget_code", 1).get(0);
            for (CostDealerDetailEntity entity : list) {
                if (!StringUtils.isNotBlank((CharSequence)entity.getSendTpmStatus()) || SendTpmStatusEnum.YES.getCode().equals(entity.getSendTpmCode())) continue;
                total = total.add(entity.getAmount());
                entity.setSendTpmStatus(SendTpmStatusEnum.YES.getCode());
                entity.setSendTpmCode(tpmBusiness);
                entityList.add(entity);
            }
            FeeBudgetChangeVo vo = new FeeBudgetChangeVo();
            vo.setBusinessCode(tpmBusiness);
            vo.setAmount(total);
            vo.setIsDeduction(Boolean.valueOf(true));
            vo.setCustomerCode("CPS");
            vo.setCustomerName("CPS\u8d39\u7528");
            log.info("tpm\u8d39\u7528\u6263\u51cf\u5165\u53c2={}", (Object)JSONArray.toJSONString((Object)vo));
            Result result = this.cpsTpmFeign.feeBudgetChange(vo);
            log.info("tpm\u8d39\u7528\u6263\u51cf\u8fd4\u56de={}", (Object)JSONArray.toJSONString((Object)result));
            if (result.isSuccess()) {
                this.costDealerDetailRepository.saveOrUpdateBatch(entityList);
                return true;
            }
            return false;
        }
        return true;
    }

    public Map<String, Date> getTimeByCalender() {
        Hashtable<String, Date> map = new Hashtable<String, Date>();
        Date date = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, -1);
        calendar.set(10, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        Date startTime = calendar.getTime();
        map.put("startTime", startTime);
        calendar.set(10, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        Date endTime = calendar.getTime();
        map.put("endTime", endTime);
        return map;
    }
}

