/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.reward.cost.local.service.observer;

import com.biz.crm.cps.business.participator.sdk.common.enums.ParticipatorTypeEnum;
import com.biz.crm.cps.business.reward.cost.local.entity.CostDealerDetailEntity;
import com.biz.crm.cps.business.reward.cost.local.entity.CostDealerEntity;
import com.biz.crm.cps.business.reward.cost.local.entity.CostTerminalDetailEntity;
import com.biz.crm.cps.business.reward.cost.local.entity.CostTerminalEntity;
import com.biz.crm.cps.business.reward.cost.local.service.CostDealerDetailService;
import com.biz.crm.cps.business.reward.cost.local.service.CostTerminalDetailService;
import com.biz.crm.cps.business.reward.sdk.dto.RewardConditionDto;
import com.biz.crm.cps.business.reward.sdk.service.observer.RewardMountRegister;
import com.biz.crm.cps.business.reward.sdk.service.observer.RewardServiceObserver;
import com.biz.crm.cps.business.reward.sdk.service.strategy.RewardComputeStrategy;
import com.biz.crm.cps.business.reward.sdk.service.strategy.RewardComputeStrategyHolder;
import com.biz.crm.cps.business.reward.sdk.vo.ComputeCashVo;
import com.bizunited.platform.common.service.NebulaToolkitService;
import java.math.BigDecimal;
import jodd.util.StringUtil;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="CostRewardServiceObserverImpl")
public class CostRewardServiceObserverImpl
implements RewardServiceObserver {
    private static final Logger log = LoggerFactory.getLogger(CostRewardServiceObserverImpl.class);
    @Autowired
    @Qualifier(value="CostRewardMountRegisterServiceImpl")
    private RewardMountRegister rewardMountRegister;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private RewardComputeStrategyHolder rewardComputeStrategyHolder;
    @Autowired
    private CostDealerDetailService costDealerDetailService;
    @Autowired
    private CostTerminalDetailService costTerminalDetailService;

    @Transactional
    public void onCreate(RewardConditionDto item) {
        Validate.notNull((Object)item, (String)"\u5956\u52b1\u6761\u4ef6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)item.getRewardMethodFlag(), (String)"\u5956\u52b1\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)item.getAwardConditionFlag(), (String)"\u5956\u52b1\u8ba1\u7b97\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        if (StringUtil.equals((String)item.getRewardMethodFlag(), (String)this.rewardMountRegister.getKey())) {
            BigDecimal amount;
            Validate.notNull((Object)this.rewardComputeStrategyHolder, (String)"\u5956\u52b1\u8ba1\u7b97\u7b56\u7565\u63a7\u5236\u5668\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            RewardComputeStrategy computeStrategy = this.rewardComputeStrategyHolder.getStrategy(item.getAwardConditionFlag());
            Validate.notNull((Object)computeStrategy, (String)"\u8d39\u7528\u5956\u52b1\u8ba1\u7b97\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            ComputeCashVo computeCashVo = computeStrategy.calculate(item);
            BigDecimal bigDecimal = amount = computeCashVo.getRecordCash() == null ? BigDecimal.ZERO : computeCashVo.getRecordCash();
            if (ParticipatorTypeEnum.DEALER.getDictCode().equals(item.getAdditionalParticipatorFlag())) {
                CostDealerEntity dealerEntity = new CostDealerEntity();
                dealerEntity.setDealerCode(item.getAdditionalParticipatorCode());
                dealerEntity.setDealerName(item.getAdditionalParticipatorName());
                dealerEntity.setChannel(item.getChannel());
                dealerEntity.setOrgCode(item.getOrgCode());
                dealerEntity.setOrgName(item.getOrgName());
                dealerEntity.setPhone(item.getPhone());
                CostDealerDetailEntity dealerDetailEntity = new CostDealerDetailEntity();
                dealerDetailEntity.setInOrOut(1);
                dealerDetailEntity.setCostType(1);
                dealerDetailEntity.setSourceCode(item.getTriggerObject());
                dealerDetailEntity.setSourceType(item.getTriggerAction());
                dealerDetailEntity.setRecordCode(item.getRecordCode());
                dealerDetailEntity.setAgreementCode(item.getAgreementCode());
                dealerDetailEntity.setPolicyName(item.getPolicyName());
                dealerDetailEntity.setTemplateCode(item.getTemplateCode());
                dealerDetailEntity.setAmount(amount);
                dealerDetailEntity.setBillState(2);
                dealerDetailEntity.setDealerCode(item.getAdditionalParticipatorCode());
                dealerDetailEntity.setDealer(dealerEntity);
                this.costDealerDetailService.create(dealerDetailEntity);
            }
            if (ParticipatorTypeEnum.TERMINAL.getDictCode().equals(item.getAdditionalParticipatorFlag())) {
                CostTerminalEntity terminalEntity = new CostTerminalEntity();
                terminalEntity.setTerminalCode(item.getAdditionalParticipatorCode());
                terminalEntity.setTerminalName(item.getAdditionalParticipatorName());
                terminalEntity.setChannel(item.getChannel());
                terminalEntity.setOrgCode(item.getOrgCode());
                terminalEntity.setOrgName(item.getOrgName());
                terminalEntity.setPhone(item.getPhone());
                CostTerminalDetailEntity terminalDetailEntity = new CostTerminalDetailEntity();
                terminalDetailEntity.setInOrOut(1);
                terminalDetailEntity.setCostType(1);
                terminalDetailEntity.setSourceCode(item.getTriggerObject());
                terminalDetailEntity.setSourceType(item.getTriggerAction());
                terminalDetailEntity.setRecordCode(item.getRecordCode());
                terminalDetailEntity.setAgreementCode(item.getAgreementCode());
                terminalDetailEntity.setTemplateCode(item.getTemplateCode());
                terminalDetailEntity.setPolicyName(item.getPolicyName());
                terminalDetailEntity.setAmount(amount);
                terminalDetailEntity.setAuditState(1);
                terminalDetailEntity.setTerminalCode(item.getAdditionalParticipatorCode());
                terminalDetailEntity.setTerminal(terminalEntity);
                this.costTerminalDetailService.create(terminalDetailEntity);
            }
        }
    }
}

