package com.biz.crm.cps.business.reward.cost.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * 经销商费用上账dto
 *
 * @Author: zengxingwang
 * @Date: 2021/8/5 10:32
 */
@Data
@ApiModel(description = "经销商费用上账dto")
public class CostDealerBillDto {

  /**
   * 经销商编码
   */
  @ApiModelProperty("经销商编码")
  private String dealerCode;

  /**
   * 经销商名称
   */
  @ApiModelProperty("经销商名称")
  private String dealerName;

  /**
   * 渠道类型
   */
  @ApiModelProperty("渠道类型")
  private String channel;

  /**
   * 所属组织编码
   */
  @ApiModelProperty("所属组织编码")
  private String orgCode;

  /**
   * 所属组织名称
   */
  @ApiModelProperty("所属组织名称")
  private String orgName;

  /**
   * 上账类型（1.货补2.折扣）
   */
  @ApiModelProperty("上账类型（1.货补2.折扣）")
  private Integer billType;

  /**
   * 开始创建时间
   */
  @ApiModelProperty("开始创建时间")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss" )
  private Date createTimeStart;

  /**
   * 结束创建时间
   */
  @ApiModelProperty("结束创建时间")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss" )
  private Date createTimeEnd;

  /**
   * 租户编号 不用向外暴露
   */
  @ApiModelProperty("租户编号")
  private String tenantCode;
}
