package com.biz.crm.cps.business.reward.cost.sdk.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * @Author: zengxingwang
 * @Date: 2021/11/16 16:26
 */
@Data
public class CostDealerDetailDto {

  /**
   * 主键
   */
  @ApiModelProperty("主键")
  private String id;

  /**
   * 租户编码
   */
  @ApiModelProperty("租户编码")
  private String tenantCode;

  /**
   * 费用变动流水编码
   */
  @ApiModelProperty("费用变动流水编码")
  private String code;

  /**
   * 所属组织名称
   */
  @ApiModelProperty("所属组织名称")
  private String orgName;

  /**
   * 所属客户组织名称
   */
  @ApiModelProperty("所属客户组织名称")
  private String cusOrgName;

  /**
   * 客户类型
   */
  @ApiModelProperty("客户类型")
  private String customerType;

  /**
   * 渠道类型
   */
  @ApiModelProperty("渠道类型")
  private String channel;

  /**
   * 客户编码
   */
  @ApiModelProperty("客户编码")
  private String customerCode;

  /**
   * 客户名称
   */
  @ApiModelProperty("客户名称")
  private String customerName;

  /**
   * 客户标签
   */
  @ApiModelProperty("客户标签")
  private String tag;

  /**
   * 变更事件
   */
  @ApiModelProperty(value = "变更事件")
  private String rebateType;

  /**
   * 模板名称
   */
  @ApiModelProperty(value = "模板名称")
  private String templateName;

  /**
   * 创建开始时间
   */
  @ApiModelProperty(value = "创建开始时间")
  @JsonFormat(locale="zh", timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss" )
  private Date startCreateTime;

  /**
   * 创建结束时间
   */
  @ApiModelProperty(value = "创建结束时间")
  @JsonFormat(locale="zh", timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss" )
  private Date endCreateTime;

}
