package com.biz.crm.cps.business.reward.cost.sdk.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @ClassName: RewardConditionDto
 * @Author: yangfan
 * @Description: 奖励条件信息
 * @Date: 2021/8/13 15:45
 * @Version: 1.0
 */
@Data
public class CostDetailDto implements Serializable {
  private static final long serialVersionUID = -6809276319557607168L;

  /**
   * ParticipatorTypeEnum
   * 参与者类型 1-经销商，2-终端，3-消费者
   */
  @ApiModelProperty("参与者类型")
  private String participatorType;

  /**
   * 参与者编码
   */
  @ApiModelProperty("参与者编码")
  private String participatorCode;

  /**
   * 参与者名称
   */
  @ApiModelProperty("参与者名称")
  private String participatorName;

  /**
   * 业务类型 = 触发动作
   */
  @ApiModelProperty("业务类型")
  @TableField(value = "source_type")
  private String sourceType;

  /**
   * 业务来源编号 = 触发对象
   */
  @ApiModelProperty("业务来源编号")
  @TableField(value = "source_code")
  private String sourceCode;

  /**
   * 分利费用
   */
  @ApiModelProperty("分利费用")
  @TableField(value = "amount")
  private BigDecimal amount;

  /**
   * 协议编码
   */
  @ApiModelProperty("协议编码")
  @TableField(value = "agreement_code")
  private String agreementCode;

  /**
   * 扫码记录编码
   */
  @ApiModelProperty("扫码记录编码")
  @TableField(value = "record_code")
  private String recordCode;

  /**
   * 收/支（1.收2.支）
   */
  @ApiModelProperty("收/支（1.收2.支）")
  private Integer inOrOut;

  /**
   * 触发动作所属政策
   */
  @ApiModelProperty(value = "政策名称")
  private String policyName;

  /**
   * 模板编码
   */
  @ApiModelProperty(value = "模板编码")
  private String templateCode;

  /**
   * 费用类型（1.分利；2.上账; 3、兑换）
   */
  @ApiModelProperty("费用类型（1.分利；2.上账）")
  private Integer costType;

  /**
   * 正向、反向
   *
   * @see com.biz.crm.cps.business.policy.scan.sdk.common.enums.RebateTypeEnum dictCode
   */
  @ApiModelProperty(value = "正向、反向")
  private String rebateType;

}
