package com.biz.crm.cps.business.reward.cost.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * 终端费用dto
 *
 * @Author: zengxingwang
 * @Date: 2021/8/5 10:32
 */
@Data
@ApiModel(description = "终端费用dto")
public class CostTerminalDto {

  /**
   * 终端编码
   */
  @ApiModelProperty("终端编码")
  private String terminalCode;

  /**
   * 终端名称
   */
  @ApiModelProperty("终端名称")
  private String terminalName;

  /**
   * 渠道类型
   */
  @ApiModelProperty("渠道类型")
  private String channel;

  /**
   * 客户标签
   */
  @ApiModelProperty("客户标签")
  private String tag;

  /**
   * 所属组织编码
   */
  @ApiModelProperty("所属组织编码")
  private String orgCode;

  /**
   * 所属组织名称
   */
  @ApiModelProperty("所属组织名称")
  private String orgName;

  /**
   * 省编码
   */
  @ApiModelProperty("省编码")
  private String provinceCode;

  /**
   * 省名称
   */
  @ApiModelProperty("省名称")
  private String provinceName;

  /**
   * 市编码
   */
  @ApiModelProperty("市编码")
  private String cityCode;

  /**
   * 市名称
   */
  @ApiModelProperty("市名称")
  private String cityName;

  /**
   * 区/县编码
   */
  @ApiModelProperty("区/县编码")
  private String districtCode;

  /**
   * 区/县名称
   */
  @ApiModelProperty("区/县名称")
  private String districtName;

  /**
   * 开始修改时间
   */
  @ApiModelProperty("开始修改时间")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss" )
  private Date updateTimeStart;

  /**
   * 结束修改时间
   */
  @ApiModelProperty("结束修改时间")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss" )
  private Date updateTimeEnd;

  /**
   * 租户编号 不用向外暴露
   */
  @ApiModelProperty("租户编号")
  private String tenantCode;

  /**
   * 审核状态(1.待审核2.通过3.驳回)
   */
  @ApiModelProperty("审核状态(1.待审核2.通过3.驳回)")
  private Integer reviewStatus;
}
