package com.biz.crm.cps.business.reward.cost.sdk.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.bizunited.nebula.common.vo.UuidVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * 经销商货补上账明细
 *
 * @Author: zengxingwang
 * @Date: 2021/8/5 10:32
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "CostDealerBillDetailVo", description = "经销商货补上账明细")
public class CostDealerBillDetailVo extends UuidVo {

  /**
   * 物料编码
   */
  @ApiModelProperty("物料编码")
  private String materialCode;

  /**
   * 物料名称
   */
  @ApiModelProperty("物料名称")
  private String materialName;

  /**
   * 本次费用
   */
  @ApiModelProperty("本次费用")
  @TableField(value = "amount")
  private BigDecimal amount;

  /**
   * 上账id
   */
  @ApiModelProperty("上账id")
  @TableField(value = "cost_dealer_bill_id")
  private String costDealerBillId;
}
