package com.biz.crm.cps.business.reward.cost.sdk.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @Author: zengxingwang
 * @Date: 2021/9/16 9:54
 */
@Data
public class CostDealerBillVo {

  /**
   * 经销商编码
   */
  @ApiModelProperty("经销商编码")
  private String dealerCode;

  /**
   * 经销商名称
   */
  @ApiModelProperty("经销商名称")
  private String dealerName;

  /**
   * 渠道类型
   */
  @ApiModelProperty("渠道类型")
  private String channel;

  /**
   * 上账类型（1.货补2.折扣）
   */
  @ApiModelProperty("上账类型（1.货补2.折扣）")
  private Integer billType;

  /**
   * 所属组织编码
   */
  @ApiModelProperty("所属组织编码")
  private String orgCode;

  /**
   * 所属组织名称
   */
  @ApiModelProperty("所属组织名称")
  private String orgName;

  /**
   * 业务来源编号
   */
  @ApiModelProperty("业务来源编号")
  private String sourceCode;

  /**
   * 已上账费用
   */
  @ApiModelProperty("已上账费用")
  private BigDecimal billedFee;

  /**
   * 总上账费用金额
   */
  @ApiModelProperty("总上账费用金额")
  private BigDecimal totalFee;

  /**
   * 收/支（1.收2.支）
   */
  @ApiModelProperty("收/支（1.收2.支）")
  private Integer inOrOut;

  @ApiModelProperty(value = "创建时间")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss" , timezone = "GMT+8")
  private Date createTime;

  @ApiModelProperty(value = "创建人账号")
  private String createAccount;
}
