package com.biz.crm.cps.business.reward.cost.sdk.vo;

import com.biz.crm.cps.business.participator.sdk.vo.ParticipatorTagVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @Author: zengxingwang
 * @Date: 2021/11/16 16:25
 */
@Data
public class CostDealerDetailVo {

  /**
   * 主键
   */
  @ApiModelProperty("主键")
  private String id;

  /**
   * 费用变动流水编码
   */
  @ApiModelProperty("费用变动流水编码")
  private String code;

  /**
   * 所属组织名称
   */
  @ApiModelProperty("所属组织名称")
  private String orgName;

  /**
   * 所属客户组织名称
   */
  @ApiModelProperty("所属客户组织名称")
  private String cusOrgName;

  /**
   * 经销商类型
   */
  @ApiModelProperty("经销商类型")
  private String customerType;

  /**
   * 经销商标签列表
   */
  private List<ParticipatorTagVo> participatorTagVos;

  /**
   * 经销商标签
   */
  @ApiModelProperty("经销商标签")
  private String tag;

  /**
   * 渠道类型
   */
  @ApiModelProperty("渠道类型")
  private String channel;

  /**
   * 客户编码
   */
  @ApiModelProperty("客户编码")
  private String customerCode;

  /**
   * 客户名称
   */
  @ApiModelProperty("客户名称")
  private String customerName;

  /**
   * 变更事件
   */
  @ApiModelProperty(value = "变更事件")
  private String policyName;

  /**
   * 模板名称
   */
  @ApiModelProperty(value = "模板名称")
  private String templateName;

  /**
   * 变更金额
   */
  @ApiModelProperty(value = "变更金额")
  private BigDecimal amount;

  /**
   * 余额
   */
  @ApiModelProperty(value = "余额")
  private BigDecimal balance;

  /**
   * 变更时间
   */
  @ApiModelProperty(value = "变更时间")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  private Date createTime;

  @ApiModelProperty(value = "正向、反向")
  private String rebateType;

  @ApiModelProperty(value = "扫码编码")
  private String recordCode;

  @ApiModelProperty(value = "触发对象")
  private String triggerObject;

  /**
   * 收/支（1.收2.支）
   */
  @ApiModelProperty("收/支（1.收2.支）")
  private Integer inOrOut;
}
