package com.biz.crm.cps.business.reward.cost.sdk.vo;

import com.bizunited.nebula.common.vo.UuidVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Set;

/**
 * @ClassName: CashRandomVo
 * @Author: yangfan
 * @Description: H5明细统计vo
 * @Date: 2021/8/9 15:05
 * @Version: 1.0
 */

@Data
@ApiModel(value = "CostDetailVo", description = "H5明细统计vo")
public class CostDetailVo extends UuidVo {


  /**
   * 费用变动流水编码
   */
  @ApiModelProperty("费用变动流水编码")
  private String costCode;

  /**
   * 协议编码
   */
  @ApiModelProperty("协议编码")
  private String agreementCode;

  /**
   * 扫码编码
   */
  @ApiModelProperty("扫码编码")
  private String recordCode;

  /**
   * 协议名称
   */
  @ApiModelProperty("协议名称")
  private String agreementName;

  /**
   * 模板编码
   */
  @ApiModelProperty(value = "模板编码")
  private String templateCode;

  /**
   * 模板名称
   */
  @ApiModelProperty(value = "模板名称")
  private String templateName;

  /**
   * 政策名称
   */
  @ApiModelProperty("政策名称")
  private String policyName;

  /**
   * 编码
   */
  @ApiModelProperty("编码")
  private String code;

  /**
   * 费用类型（1.分利；2.上账）
   */
  @ApiModelProperty("费用类型（1.分利；2.上账）")
  private Integer costType;

  /**
   * 上账类型（1.货补2.折扣）
   */
  @ApiModelProperty("上账类型（1.货补2.折扣）")
  private Integer billType;

  /**
   * 创建时间
   */
  @ApiModelProperty("创建时间")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss" , timezone = "GMT+8")
  private Date createTime;

  /**
   * 金额
   */
  @ApiModelProperty("金额")
  private BigDecimal amount;

  /**
   * 余额
   */
  @ApiModelProperty("余额")
  private BigDecimal balance;

  /**
   * 收/支（1.收2.支）
   */
  @ApiModelProperty("收/支（1.收2.支）")
  private Integer inOrOut;

  /**
   * 上账物料
   */
  @ApiModelProperty("上账物料")
  private Set<CostDealerBillDetailVo> billDetailVos;

  @ApiModelProperty(value = "正向、反向")
  private String rebateType;

}
