package com.biz.crm.cps.business.reward.cost.sdk.vo;

import com.biz.crm.cps.business.participator.sdk.vo.ParticipatorTagVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 终端费用上账流水
 *
 * @Author: zengxingwang
 * @Date: 2021/8/5 10:32
 */
@Data
public class CostTerminalBillVo{

  /**
   * 业务来源编号
   */
  @ApiModelProperty("业务来源编号")
  private String sourceCode;

  /**
   * 终端编码
   */
  @ApiModelProperty("终端编码")
  private String terminalCode;

  /**
   * 终端名称
   */
  @ApiModelProperty("终端名称")
  private String terminalName;

  /**
   * 渠道类型
   */
  @ApiModelProperty("渠道类型")
  private String channel;

  /**
   * 客户标签
   */
  @ApiModelProperty("客户标签")
  private String tag;

  /**
   * 客户标签列表
   */
  @ApiModelProperty("客户标签列表")
  private List<ParticipatorTagVo> participatorTagVos;

  /**
   * 所属组织编码
   */
  @ApiModelProperty("所属组织编码")
  private String orgCode;

  /**
   * 所属组织名称
   */
  @ApiModelProperty("所属组织名称")
  private String orgName;

  /**
   * 核销金额
   */
  @ApiModelProperty("核销金额")
  private BigDecimal amount;

  /**
   * 剩余可核销费用
   */
  @ApiModelProperty("剩余可核销费用")
  private BigDecimal unAuditFee;

  /**
   * 审核状态(1.待审核2.通过3.驳回)
   */
  @ApiModelProperty("审核状态(1.待审核2.通过3.驳回)")
  private Integer reviewStatus;

  /**
   * 省编码
   */
  @ApiModelProperty("省编码")
  private String provinceCode;

  /**
   * 省名称
   */
  @ApiModelProperty("省名称")
  private String provinceName;

  /**
   * 市编码
   */
  @ApiModelProperty("市编码")
  private String cityCode;

  /**
   * 市名称
   */
  @ApiModelProperty("市名称")
  private String cityName;

  /**
   * 区/县编码
   */
  @ApiModelProperty("区/县编码")
  private String districtCode;

  /**
   * 区/县名称
   */
  @ApiModelProperty("区/县名称")
  private String districtName;

  /**
   * 收/支（1.收2.支）
   */
  @ApiModelProperty("收/支（1.收2.支）")
  private Integer inOrOut;

  /**
   * 提交时间
   */
  @ApiModelProperty("提交时间")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss" )
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss" , timezone = "GMT+8")
  private Date submitTime;

  /**
   * 审核时间
   */
  @ApiModelProperty("审核时间")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss" )
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss" , timezone = "GMT+8")
  private Date auditTime;

  /**
   * 驳回时间
   */
  @ApiModelProperty("驳回时间")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss" )
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss" , timezone = "GMT+8")
  private Date rejectTime;
}
