package com.biz.crm.cps.business.reward.cost.sdk.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @Author: zengxingwang
 * @Date: 2021/11/16 16:25
 */
@Data
public class CostTerminalDetailVo {

  /**
   * 主键
   */
  @ApiModelProperty("主键")
  private String id;

  /**
   * 费用变动流水编码
   */
  @ApiModelProperty("费用变动流水编码")
  private String code;

  /**
   * 所属组织名称
   */
  @ApiModelProperty("所属组织名称")
  private String orgName;

  /**
   * 所属客户组织名称
   */
  @ApiModelProperty("所属客户组织名称")
  private String cusOrgName;

  /**
   * 终端类型
   */
  @ApiModelProperty("终端类型")
  private String terminalType;

  /**
   * 终端标签
   */
  @ApiModelProperty("终端标签")
  private String tag;

  /**
   * 渠道类型
   */
  @ApiModelProperty("渠道类型")
  private String channel;

  /**
   * 终端编码
   */
  @ApiModelProperty("终端编码")
  private String terminalCode;

  /**
   * 终端名称
   */
  @ApiModelProperty("终端名称")
  private String terminalName;

  /**
   * 变更事件
   */
  @ApiModelProperty(value = "变更事件")
  private String policyName;

  /**
   * 模板名称
   */
  @ApiModelProperty(value = "模板名称")
  private String templateName;

  /**
   * 变更金额
   */
  @ApiModelProperty(value = "变更金额")
  private BigDecimal amount;

  /**
   * 余额
   */
  @ApiModelProperty(value = "余额")
  private BigDecimal balance;

  /**
   * 变更时间
   */
  @ApiModelProperty(value = "变更时间")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  private Date createTime;

  @ApiModelProperty(value = "正向、反向")
  private String rebateType;

  @ApiModelProperty(value = "扫码编码")
  private String recordCode;

  @ApiModelProperty(value = "触发对象")
  private String triggerObject;

  /**
   * 收/支（1.收2.支）
   */
  @ApiModelProperty("收/支（1.收2.支）")
  private Integer inOrOut;
}
