package com.biz.crm.cps.business.reward.gift.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.common.local.model.Result;
import com.biz.crm.cps.business.reward.gift.local.entity.RewardGiftDetail;
import com.biz.crm.cps.business.reward.gift.local.service.RewardGiftDetailService;
import com.biz.crm.cps.business.reward.gift.sdk.dto.ActivityDto;
import com.biz.crm.cps.business.reward.gift.sdk.dto.RewardGiftDetailDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 奖励赠品流水明细
 * @author songjingen
 */
@RestController
@RequestMapping("/v1/gift/rewardGiftDetail")
@Slf4j
@Api(tags = "奖励赠品流水明细")
public class RewardGiftDetailController {

  @Autowired
  private RewardGiftDetailService rewardGiftDetailService;

  /**
   * 奖励赠品流水明细分页查询
   * @return
   */
  @GetMapping("/findByConditions")
  @ApiOperation("奖励赠品流水明细分页查询")
  public Result<Page<RewardGiftDetail>> findByConditions(@ApiParam(name = "dto", value = "奖励赠品明细信息dto") RewardGiftDetailDto dto, @PageableDefault(50) Pageable pageable) {
    try {
      return Result.ok(this.rewardGiftDetailService.findByConditions(pageable, dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 增加奖励赠品流水明细
   * @return
   */
  @PostMapping
  @ApiOperation("新增")
  public Result<?> create(@ApiParam(name = "dto", value = "奖励赠品明细信息dto") RewardGiftDetailDto dto) {
    try {
      this.rewardGiftDetailService.create(dto);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 活动选择奖品
   * @return
   */
  @PostMapping("updateTypeByActivityAndParticipatorAndProduct")
  @ApiOperation("活动选择奖品")
  public Result<RewardGiftDetail> updateTypeByActivityAndParticipatorAndProduct(@RequestBody ActivityDto dto) {
    try {

      return Result.ok(this.rewardGiftDetailService.updateTypeByActivityAndParticipatorAndProduct(dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
