package com.biz.crm.cps.business.reward.gift.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import java.util.Set;

/**
 * 奖励赠品主表
 * @author songjingen
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "RewardGift", description = "奖励赠品")
@TableName("reward_gift")
public class RewardGift extends TenantFlagOpEntity {
  private static final long serialVersionUID = 8190467636664597283L;

  /**
   * 参与者编码
   */
  @ApiModelProperty("客户编码")
  @TableField(value = "participator_code")
  @Column(name = "participator_code", length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 客户编码 '")
  private String participatorCode;

  /**
   * 参与者名称
   */
  @ApiModelProperty("客户名称")
  @TableField(value = "participator_name")
  @Column(name = "participator_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 客户名称 '")
  private String participatorName;

  /**
   * 参与者类型
   */
  @ApiModelProperty("客户类型")
  @TableField(value = "participator_type")
  @Column(name = "participator_type", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 客户类型 '")
  private String participatorType;

  /**
   * 渠道
   */
  @ApiModelProperty("渠道")
  @TableField(value = "channel")
  @Column(name = "channel", length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 渠道 '")
  private String channel;

  /**
   * 客户标签
   */
  @ApiModelProperty("客户标签")
  @TableField(value = "tag")
  @Column(name = "tag", length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 客户标签 '")
  private String tag;

  /**
   * 所属组织编码
   */
  @ApiModelProperty("所属组织编码")
  @TableField(value = "org_code")
  @Column(name = "org_code", length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 所属组织编码 '")
  private String orgCode;

  /**
   * 所属组织名称
   */
  @ApiModelProperty("所属组织名称")
  @TableField(value = "org_name")
  @Column(name = "org_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 所属组织名称 '")
  private String orgName;

  /**
   * 联系电话
   */
  @ApiModelProperty("联系电话")
  @TableField(value = "phone")
  @Column(name = "phone", length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 联系电话 '")
  private String phone;

  /**
   * 明细
   */
  @ApiModelProperty("明细")
  @TableField(exist = false)
  private Set<RewardGiftDetail> rewardGiftDetails;

  /**
   * 赠品物料集合
   */
  @ApiModelProperty("赠品物料集合")
  @TableField(exist = false)
  private Set<RewardGiftMaterial> rewardGiftMaterials;
}
