package com.biz.crm.cps.business.reward.gift.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import java.math.BigDecimal;

/**
 * 奖励赠品流水明细表
 *
 * @author songjingen
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "RewardGiftDetail", description = "奖励赠品流水明细")
@TableName("reward_gift_detail")
public class RewardGiftDetail extends TenantFlagOpEntity {

  private static final long serialVersionUID = -5387176716047899897L;

  /**
   * 赠品变动流水编码
   */
  @ApiModelProperty("赠品变动流水编码")
  @TableField(value = "code")
  @Column(name = "code", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 赠品变动流水编码 '")
  private String code;

  /**
   * 参与者类型
   */
  @ApiModelProperty("参与者类型")
  @TableField(value = "participator_type")
  @Column(name = "participator_type", length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 参与者类型 '")
  private String participatorType;

  /**
   * 参与者编码
   */
  @ApiModelProperty("参与者编码")
  @TableField(value = "participator_code")
  @Column(name = "participator_code", length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 参与者编码 '")
  private String participatorCode;

  /**
   * 参与者名称
   */
  @ApiModelProperty("参与者名称")
  @TableField(value = "participator_name")
  @Column(name = "participator_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 参与者名称 '")
  private String participatorName;

  /**
   * 手机号
   */
  @ApiModelProperty("手机号")
  @TableField(value = "phone")
  @Column(name = "phone", length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 手机号 '")
  private String phone;

  /**
   *
   * <pre>
   * 1、红包提现；
   * 2、惩罚扣除（可能有）；
   * 3、扫箱码；
   * 4、扫盖内码；
   * 5、扫盒码；
   * 6、包量任务分利；
   * 7、陈列任务分利；
   * 8、支付扫码分利（后续控价涉及）；
   * 9、活动奖励；
   * </pre>
   * 触发动作
   */
  @ApiModelProperty("触发动作")
  @TableField(value = "trigger_action ")
  @Column(name = "trigger_action", length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 触发动作 '")
  private String triggerAction;

  /**
   * 触发对象
   */
  @ApiModelProperty("触发对象")
  @TableField(value = "trigger_object")
  @Column(name = "trigger_object", length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 触发对象 '")
  private String triggerObject;

  /**
   * 赠品物料编码
   */
  @ApiModelProperty("赠品物料编码")
  @TableField(value = "material_code")
  @Column(name = "material_code", length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 赠品物料编码 '")
  private String materialCode;

  /**
   * 赠品物料名称
   */
  @ApiModelProperty("赠品物料名称")
  @TableField(value = "material_name")
  @Column(name = "material_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 赠品物料名称 '")
  private String materialName;

  /**
   * 赠品变动数量
   */
  @ApiModelProperty("赠品变动数量")
  @TableField(value = "amount")
  @Column(name = "amount", precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT ' 赠品变动数量 '")
  private BigDecimal amount;

  /**
   * 赠品剩余数量
   */
  @ApiModelProperty("赠品剩余数量")
  @TableField(value = "balance")
  @Column(name = "balance", precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT ' 赠品剩余数量 '")
  private BigDecimal balance;

  /**
   * 赠品id
   */
  @ApiModelProperty("赠品id")
  @TableField(value = "reward_gift_id")
  @Column(name = "reward_gift_id", length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 赠品id '")
  private String rewardGiftId;
  /**
   * 协议模版编码
   */
  @ApiModelProperty("协议模版编码")
  @TableField(value = "template_code")
  @Column(name = "template_code", length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 协议模版编码 '")
  private String templateCode;

  /**
   * 协议编码
   */
  @ApiModelProperty("协议编码")
  @TableField(value = "agreement_code")
  @Column(name = "agreement_code", length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 协议编码 '")
  private String agreementCode;
  /**
   * 触发动作所属政策
   */
  @ApiModelProperty("政策名称")
  @TableField(value = "policy_name")
  @Column(name = "policy_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 政策名称 '")
  private String policyName;
  /**
   * 扫码记录编码
   */
  @ApiModelProperty("扫码记录编码")
  @TableField(value = "record_code")
  @Column(name = "record_code", length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 扫码记录编码 '")
  private String recordCode;

  /**
   * 操作类型，1：增加 2：减少
   */
  @ApiModelProperty("操作类型，1：增加 2：减少")
  @TableField(value = "type")
  @Column(name = "type", length = 32, columnDefinition = "VARCHAR(128) COMMENT ' 操作类型，1：增加 2：减少 '")
  private String type;
  /**
   * 奖励赠品信息
   */
  @ApiModelProperty("奖励赠品信息")
  @TableField(exist = false)
  private RewardGift rewardGift;


  /**
   * 奖项编码
   */
  @ApiModelProperty("奖项编码")
  @TableField(value = "reward_code")
  private String rewardCode;
}
