package com.biz.crm.cps.business.reward.gift.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.UuidOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import java.math.BigDecimal;

/**
 * 奖励赠品物料表
 * @author songjingen
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "RewardGiftMaterial", description = "奖励赠品物料")
@TableName("reward_gift_material")
public class RewardGiftMaterial extends UuidOpEntity {
  /**
   * 
   */
  private static final long serialVersionUID = -371456518434990287L;
  /**
   * 赠品id
   */
  @ApiModelProperty("赠品id")
  @TableField(value = "reward_gift_id")
  @Column(name = "reward_gift_id", length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 赠品id '")
  private String rewardGiftId;

  /**
   * 赠品物料编码
   */
  @ApiModelProperty("赠品物料编码")
  @TableField(value = "material_code")
  @Column(name = "material_code", length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 赠品物料编码 '")
  private String materialCode;

  /**
   * 赠品物料名称
   */
  @ApiModelProperty("赠品物料名称")
  @TableField(value = "material_name")
  @Column(name = "material_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 赠品物料名称 '")
  private String materialName;

  /**
   * 赠品累计数量d
   */
  @ApiModelProperty("赠品累计数量")
  @TableField(value = "amount")
  @Column(name = "amount", precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT ' 赠品累计数量 '")
  private BigDecimal amount;

  /**
   * 赠品剩余数量
   */
  @ApiModelProperty("赠品剩余数量")
  @TableField(value = "balance")
  @Column(name = "balance", precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT ' 赠品剩余数量 '")
  private BigDecimal balance;
}
