package com.biz.crm.cps.business.reward.gift.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.reward.gift.local.entity.RewardGiftDetail;
import com.biz.crm.cps.business.reward.gift.sdk.dto.ActivityDto;
import com.biz.crm.cps.business.reward.gift.sdk.dto.RewardGiftDetailDto;
import org.apache.ibatis.annotations.Param;

/**
 * 奖励赠品流水明细相关mybatis操作
 * @author songjingen
 */
public interface RewardGiftDetailMapper extends BaseMapper<RewardGiftDetail> {

  /**
   * 奖励赠品流水明细分页查询
   * @param page
   * @param dto
   * @return
   */
  Page<RewardGiftDetail> findByConditions(@Param("page") Page<RewardGiftDetail> page, @Param("dto") RewardGiftDetailDto dto);

  /**
   * 根据活动和参与者和产品查询
   * @param dto
   * @return
   */
  RewardGiftDetail findByActivityAndParticipatorAndProduct(@Param("dto") ActivityDto dto);
}
