package com.biz.crm.cps.business.reward.gift.local.repository;

import com.biz.crm.cps.business.reward.gift.local.mapper.GiftTriggerObjectStatisticsVoMapper;
import com.biz.crm.cps.business.reward.sdk.vo.TriggerObjectRewardStatisticsVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 赠品统计接口持久化
 * @Author: zengxingwang
 * @Date: 2021/11/23 15:32
 */
@Component
public class GiftTriggerObjectStatisticsVoRepository {

  @Autowired
  private GiftTriggerObjectStatisticsVoMapper giftTriggerObjectStatisticsVoMapper;

  /**
   * 赠品触发对象奖励统计
   * @param triggerAction
   * @param triggerObjects
   * @return
   */
  public List<TriggerObjectRewardStatisticsVo> findByTriggerActionAndTriggerObjects(String triggerAction, List<String> triggerObjects){
    return this.giftTriggerObjectStatisticsVoMapper.findByTriggerActionAndTriggerObjects(triggerAction, triggerObjects);
  }
}
