package com.biz.crm.cps.business.reward.gift.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.cps.business.reward.gift.local.entity.RewardGiftDetail;
import com.biz.crm.cps.business.reward.gift.local.mapper.RewardGiftDetailMapper;
import com.biz.crm.cps.business.reward.gift.sdk.dto.ActivityDto;
import com.biz.crm.cps.business.reward.gift.sdk.dto.RewardGiftDetailDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

/**
 * 奖励赠品流水明细相关数据库操作
 * @author songjingen
 */
@Component
public class RewardGiftDetailRepository extends ServiceImpl<RewardGiftDetailMapper, RewardGiftDetail> {

  @Autowired
  private RewardGiftDetailMapper rewardGiftDetailMapper;

  /**
   * 奖励赠品流水明细分页查询
   * @param pageable
   * @param dto
   * @return
   */
  public Page<RewardGiftDetail> findByConditions(Pageable pageable, RewardGiftDetailDto dto) {
    Page<RewardGiftDetail> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.rewardGiftDetailMapper.findByConditions(page, dto);
  }

  /**
   * 根据活动和参与者和产品查询
   * @param dto
   * @return
   */
  public RewardGiftDetail findByActivityAndParticipatorAndProduct(ActivityDto dto) {
    return this.rewardGiftDetailMapper.findByActivityAndParticipatorAndProduct(dto);
  }
}
