package com.biz.crm.cps.business.reward.gift.local.repository;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.cps.business.reward.gift.local.entity.RewardGiftMaterial;
import com.biz.crm.cps.business.reward.gift.local.mapper.RewardGiftMaterialMapper;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 奖励赠品物料信息相关数据库操作
 * @author songjingen
 */
@Component
public class RewardGiftMaterialRepository extends ServiceImpl<RewardGiftMaterialMapper, RewardGiftMaterial> {

  /**
   * 根据奖励赠品id查询赠品物料集合
   * @param rewardGiftId
   * @return
   */
  public List<RewardGiftMaterial> findByRewardGiftId(String rewardGiftId) {
    QueryWrapper<RewardGiftMaterial> queryWrapper = new QueryWrapper<>();
    queryWrapper.eq("reward_gift_id", rewardGiftId);
    return this.list(queryWrapper);
  }
}
