package com.biz.crm.cps.business.reward.gift.local.repository;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.cps.business.reward.gift.local.entity.RewardGift;
import com.biz.crm.cps.business.reward.gift.local.mapper.RewardGiftMapper;
import org.springframework.stereotype.Component;

/**
 * 奖励赠品相关数据库操作
 * @author songjingen
 */
@Component
public class RewardGiftRepository extends ServiceImpl<RewardGiftMapper, RewardGift> {

  /**
   * 根据参与者编码和类型查询对象
   * @param participatorCode 参与者编码
   * @param participatorType 参与者类型
   * @return
   */
  public RewardGift findByParticipatorCodeAndParticipatorType(String participatorCode, String participatorType) {
    QueryWrapper<RewardGift> queryWrapper = new QueryWrapper<>();
    queryWrapper.eq("participator_code", participatorCode);
    queryWrapper.eq("participator_type", participatorType);
    return this.getOne(queryWrapper);
  }
}
