package com.biz.crm.cps.business.reward.gift.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.reward.gift.local.entity.RewardGiftDetail;
import com.biz.crm.cps.business.reward.gift.sdk.dto.ActivityDto;
import com.biz.crm.cps.business.reward.gift.sdk.dto.RewardGiftDetailDto;
import org.springframework.data.domain.Pageable;

/**
 * 奖励赠品流水明细service
 * @author songjingen
 */
public interface RewardGiftDetailService {

  /**
   * 创建赠品流水明细记录
   * @param rewardGiftDetailDto
   */
  void create(RewardGiftDetailDto rewardGiftDetailDto);

  /**
   * 奖励赠品流水明细分页查询
   * @param pageable 分页参数
   * @param dto 查询条件
   * @return
   */
  Page<RewardGiftDetail> findByConditions(Pageable pageable, RewardGiftDetailDto dto);

  /**
   * 活动选择奖品
   * @param dto
   */
  RewardGiftDetail updateTypeByActivityAndParticipatorAndProduct(ActivityDto dto);
}
