package com.biz.crm.cps.business.reward.gift.local.service.internal;

import com.biz.crm.cps.business.reward.gift.local.repository.GiftTriggerObjectStatisticsVoRepository;
import com.biz.crm.cps.business.reward.gift.local.service.GiftTriggerObjectStatisticsVoService;
import com.biz.crm.cps.business.reward.sdk.vo.TriggerObjectRewardStatisticsVo;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * 赠品统计接口实现
 * @Author: zengxingwang
 * @Date: 2021/11/23 15:29
 */
@Service
public class GiftTriggerObjectStatisticsVoServiceImpl implements GiftTriggerObjectStatisticsVoService {

  @Autowired
  private GiftTriggerObjectStatisticsVoRepository triggerObjectStatisticsVoRepository;

  /**
   * 当统计触发事件获利事件发生时，该事件被触发。一般来说，该事件用于按协议统计红包、积分、费用获利的处理场景等
   * @param triggerAction
   * @param triggerObjects
   * @return
   */
  @Override
  public List<TriggerObjectRewardStatisticsVo> findByTriggerActionAndTriggerObjects(String triggerAction, List<String> triggerObjects) {
    if (StringUtils.isBlank(triggerAction) || CollectionUtils.isEmpty(triggerObjects)) {
      return null;
    }
    return this.triggerObjectStatisticsVoRepository.findByTriggerActionAndTriggerObjects(triggerAction, triggerObjects);
  }
}
