package com.biz.crm.cps.business.reward.gift.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.LoginUserDetailsForCPS;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.cps.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.cps.business.consumer.sdk.service.ConsumerVoService;
import com.biz.crm.cps.business.consumer.sdk.vo.ConsumerVo;
import com.biz.crm.cps.business.participator.sdk.common.enums.ParticipatorTypeEnum;
import com.biz.crm.cps.business.reward.gift.local.config.RewardGiftConfig;
import com.biz.crm.cps.business.reward.gift.local.entity.RewardGift;
import com.biz.crm.cps.business.reward.gift.local.entity.RewardGiftDetail;
import com.biz.crm.cps.business.reward.gift.local.entity.RewardGiftMaterial;
import com.biz.crm.cps.business.reward.gift.local.repository.RewardGiftDetailRepository;
import com.biz.crm.cps.business.reward.gift.local.service.RewardGiftDetailService;
import com.biz.crm.cps.business.reward.gift.local.service.RewardGiftMaterialService;
import com.biz.crm.cps.business.reward.gift.local.service.RewardGiftService;
import com.biz.crm.cps.business.reward.gift.sdk.constant.RewardGiftDetailConstant;
import com.biz.crm.cps.business.reward.gift.sdk.dto.ActivityDto;
import com.biz.crm.cps.business.reward.gift.sdk.dto.RewardGiftDetailDto;
import com.biz.crm.cps.business.reward.gift.sdk.dto.RewardGiftDto;
import com.biz.crm.cps.business.reward.gift.sdk.dto.RewardGiftMaterialDto;
import com.biz.crm.cps.business.reward.gift.sdk.event.RewardGiftDetailEventListener;
import com.biz.crm.cps.business.reward.gift.sdk.vo.RewardGiftDetailVo;
import com.biz.crm.cps.business.reward.sdk.common.enums.IncomeStatusEnum;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.web.client.RestTemplate;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * 奖励赠品流水记录接口实现
 * @author songjingen
 */
@Service
@Slf4j
public class RewardGiftDetailServiceImpl implements RewardGiftDetailService {

  @Autowired
  private RewardGiftDetailRepository rewardGiftDetailRepository;

  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;

  @Autowired
  private RewardGiftService rewardGiftService;

  @Autowired
  private RewardGiftMaterialService rewardGiftMaterialService;

  @Autowired
  private LoginUserService loginUserService;

  @Autowired
  private GenerateCodeService generateCodeService;

  @Autowired
  private RestTemplate restTemplate;

  @Autowired
  private RewardGiftConfig rewardGiftConfig;

  @Autowired
  private ConsumerVoService consumerVoService;

  @Autowired(required = false)
  private List<RewardGiftDetailEventListener> rewardGiftDetailEventListeners;

  /**
   * 创建流水明细记录
   * @param rewardGiftDetailDto
   */
  @Transactional
  @Override
  public void create(RewardGiftDetailDto rewardGiftDetailDto) {
    /**
     * 1、查询当前参与者有没有创建赠品信息
     * 2、存在赠品的信息，则判断赠品关联的赠品物料信息是否存在，
     *    存在赠品物料信息，判断赠品加减类型，计算赠品数量；
     *    不存在新增赠品物料信息和赠品信息；
     * 3、保存赠品明细记录信息
     * 4、创建活动签约任务通知
     */
    Validate.notNull(rewardGiftDetailDto, "进行此操作时，新增对象不能为空！");
    RewardGiftDetail rewardGiftDetail = this.nebulaToolkitService.copyObjectByWhiteList(rewardGiftDetailDto, RewardGiftDetail.class, null, null);
    // 1、======
    RewardGift rewardGift = rewardGiftService.findByParticipatorCodeAndParticipatorType(rewardGiftDetail.getParticipatorCode(), rewardGiftDetail.getParticipatorType());
    // 2、======
    this.createOrUpdateRewardGift(rewardGift, rewardGiftDetail);
    // 3、======
    this.buildRewardGiftDetail(rewardGiftDetail);
    this.rewardGiftDetailRepository.save(rewardGiftDetail);
    // 4、======
    if(!CollectionUtils.isEmpty(rewardGiftDetailEventListeners)){
      RewardGiftDetailVo rewardGiftDetailVo = this.nebulaToolkitService.copyObjectByWhiteList(rewardGiftDetailDto, RewardGiftDetailVo.class, null, null);
      rewardGiftDetailEventListeners.forEach(rewardGiftDetailEventListener->{
        rewardGiftDetailEventListener.onRequestCreateSignTaskActivity(rewardGiftDetailVo);
      });
    }





  }

  /**
   * 奖励赠品流水明细分页查询
   * @param pageable 分页参数
   * @param dto 查询条件
   * @return
   */
  @Override
  public Page<RewardGiftDetail> findByConditions(Pageable pageable, RewardGiftDetailDto dto) {
    ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    if (dto == null) {
      dto = new RewardGiftDetailDto();
    }
    return this.rewardGiftDetailRepository.findByConditions(pageable, dto);
  }

  /**
   * 活动选择奖品
   * @param dto
   */
  @Override
  @Transactional
  public RewardGiftDetail updateTypeByActivityAndParticipatorAndProduct(ActivityDto dto) {
    Validate.notNull(dto, "数据不能为空");
    Validate.notBlank(dto.getActivityCode(), "活动编码不能为空");
    Validate.notBlank(dto.getParticipatorCode(), "参与者编码不能为空");
    Validate.notBlank(dto.getProductCode(), "奖品编码不能为空");
    LoginUserDetailsForCPS loginUser = loginUserService.getLoginDetails(LoginUserDetailsForCPS.class);
    if(loginUser.getUsertype().equals(ParticipatorTypeEnum.CONSUMER.getKey())){
      ConsumerVo consumerVo = consumerVoService.findByExternalId(dto.getParticipatorCode());
      if(consumerVo == null){
        return null;
      }
      dto.setParticipatorCode(consumerVo.getConsumerCode());
    }
    RewardGiftDetail detail = rewardGiftDetailRepository.findByActivityAndParticipatorAndProduct(dto);
    detail.setType("3");
    rewardGiftDetailRepository.updateById(detail);
    //调用接口回调地址
    try {
      if (rewardGiftConfig != null){
        String s = this.restTemplate.postForObject(rewardGiftConfig.getNotifyUrl(), detail, String.class);
        log.info("调用实物回调接口时，返回信息，{}！",s);
      }
    } catch (RuntimeException e) {
      log.error("调用实物回调接口时，回调外部系统错误！");
    }
    return detail;
  }

  /**
   * 新增赠品物料
   * @param rewardGift
   * @param rewardGiftDetail
   * @return
   */
  private RewardGiftMaterialDto buildRewardGiftMaterialDto(RewardGift rewardGift, RewardGiftDetail rewardGiftDetail) {
    Validate.notNull(rewardGift, "创建赠品物料时，赠品信息不能为空！");
    Validate.notNull(rewardGiftDetail, "创建赠品物料时，赠品明细信息不能为空！");
    RewardGiftMaterialDto rewardGiftMaterialDto = new RewardGiftMaterialDto();
    rewardGiftMaterialDto.setRewardGiftId(rewardGift.getId());
    rewardGiftMaterialDto.setMaterialCode(rewardGiftDetail.getMaterialCode());
    rewardGiftMaterialDto.setMaterialName(rewardGiftDetail.getMaterialName());
    rewardGiftMaterialDto.setAmount(rewardGiftDetail.getAmount());
    rewardGiftMaterialDto.setBalance(rewardGiftDetail.getAmount());
    return rewardGiftMaterialDto;
  }

  /**
   * 新增赠品流水明细信息
   * @param rewardGiftDetail
   * @return
   */
  private RewardGiftDetail buildRewardGiftDetail(RewardGiftDetail rewardGiftDetail) {
    Validate.notNull(rewardGiftDetail, "创建赠品物料时，赠品明细信息不能为空！");
    Date date = new Date();
    rewardGiftDetail.setCode(generateCodeService.generateCode(RewardGiftDetailConstant.GIFT_DETAIL_FLOW, 1).get(0));
    rewardGiftDetail.setModifyAccount(loginUserService.getLoginAccountName());
    rewardGiftDetail.setModifyTime(date);
    rewardGiftDetail.setCreateAccount(loginUserService.getLoginAccountName());
    rewardGiftDetail.setCreateTime(date);
    rewardGiftDetail.setTenantCode(TenantUtils.getTenantCode());
    rewardGiftDetail.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
    rewardGiftDetail.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    return rewardGiftDetail;
  }

  /**
   * 增加或者修改赠品信息
   * @param rewardGift
   * @return
   */
  private void createOrUpdateRewardGift(RewardGift rewardGift, RewardGiftDetail rewardGiftDetail){
    if (Objects.nonNull(rewardGift)) {
      rewardGiftDetail.setRewardGiftId(rewardGift.getId());
      this.createOrUpdateRewardGiftMaterial(rewardGift, rewardGiftDetail);
    } else {
      Validate.isTrue(Objects.equals(IncomeStatusEnum.ADD.getDictCode(), rewardGiftDetail.getType()),"还未获取到赠品");
      RewardGiftDto rewardGiftDto = this.nebulaToolkitService.copyObjectByWhiteList(rewardGiftDetail, RewardGiftDto.class, null, null);
      RewardGift newRewardGift = this.rewardGiftService.create(rewardGiftDto);
      RewardGiftMaterialDto rewardGiftMaterialDto = this.buildRewardGiftMaterialDto(newRewardGift, rewardGiftDetail);
      this.rewardGiftMaterialService.create(rewardGiftMaterialDto);
      rewardGiftDetail.setRewardGiftId(newRewardGift.getId());
    }
  }

  /**
   * 创建或者修改赠品物料信息
   */
  private void createOrUpdateRewardGiftMaterial(RewardGift rewardGift, RewardGiftDetail rewardGiftDetail) {
    List<RewardGiftMaterial> rewardGiftMaterials = this.rewardGiftMaterialService.findByRewardGiftId(rewardGift.getId());
    if (Objects.nonNull(rewardGiftMaterials)) {
      List<RewardGiftMaterial> currentRewardGiftMaterials = rewardGiftMaterials.stream().filter(rewardGiftMaterial -> rewardGiftMaterial.getMaterialCode().equals(rewardGiftDetail.getMaterialCode())).collect(Collectors.toList());
      if (!CollectionUtils.isEmpty(currentRewardGiftMaterials)) {
        //计算赠品总量和余量
        RewardGiftMaterial rewardGiftMaterial = currentRewardGiftMaterials.get(0);
        BigDecimal amount = rewardGiftMaterial.getAmount() == null ? BigDecimal.ZERO : rewardGiftMaterial.getAmount();
        BigDecimal balance = rewardGiftMaterial.getBalance() == null ? BigDecimal.ZERO : rewardGiftMaterial.getBalance();
        if (Objects.equals(IncomeStatusEnum.ADD.getDictCode(), rewardGiftDetail.getType())) {
          balance = balance.add(rewardGiftDetail.getAmount()).setScale(4, RoundingMode.HALF_UP);
          amount = amount.add(rewardGiftDetail.getAmount()).setScale(4, RoundingMode.HALF_UP);
        } else if (Objects.equals(IncomeStatusEnum.SUBTRACT.getDictCode(), rewardGiftDetail.getType())) {
          Validate.isTrue(balance.compareTo(rewardGiftDetail.getAmount()) >=0,"减少赠品数量时，减少数量不能超过余量");
          balance = balance.subtract(rewardGiftDetail.getAmount()).setScale(4, RoundingMode.HALF_UP);
        }
        RewardGiftMaterialDto rewardGiftMaterialDto = this.nebulaToolkitService.copyObjectByWhiteList(rewardGiftMaterial, RewardGiftMaterialDto.class, null, null);
        rewardGiftMaterialDto.setAmount(amount);
        rewardGiftMaterialDto.setBalance(balance);
        this.rewardGiftMaterialService.update(rewardGiftMaterialDto);
        rewardGiftDetail.setBalance(balance);
        rewardGiftDetail.setRewardGiftId(rewardGift.getId());
      } else {
        RewardGiftMaterialDto rewardGiftMaterialDto = this.buildRewardGiftMaterialDto(rewardGift, rewardGiftDetail);
        this.rewardGiftMaterialService.create(rewardGiftMaterialDto);
      }
    } else {
      RewardGiftMaterialDto rewardGiftMaterialDto = this.buildRewardGiftMaterialDto(rewardGift, rewardGiftDetail);
      this.rewardGiftMaterialService.create(rewardGiftMaterialDto);
    }
  }

}
