package com.biz.crm.cps.business.reward.gift.local.service.internal;

import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.reward.gift.local.entity.RewardGiftMaterial;
import com.biz.crm.cps.business.reward.gift.local.repository.RewardGiftMaterialRepository;
import com.biz.crm.cps.business.reward.gift.local.service.RewardGiftMaterialService;
import com.biz.crm.cps.business.reward.gift.sdk.dto.RewardGiftMaterialDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;

/**
 * 奖励赠品物料信息接口实现
 * @author songjingen
 */
@Service
public class RewardGiftMaterialServiceImpl implements RewardGiftMaterialService {

  @Autowired
  private RewardGiftMaterialRepository rewardGiftMaterialRepository;

  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;

  @Autowired(required = false)
  private LoginUserService loginUserService;

  /**
   * 根据奖励赠品id查询赠品物料信息
   * @param rewardGiftId
   * @return
   */
  @Override
  public List<RewardGiftMaterial> findByRewardGiftId(String rewardGiftId) {
    if (StringUtils.isBlank(rewardGiftId)) {
      return null;
    }
    return this.rewardGiftMaterialRepository.findByRewardGiftId(rewardGiftId);
  }

  /**
   * 创建赠品物料信息
   * @param rewardGiftMaterialDto
   */
  @Override
  @Transactional
  public void create(RewardGiftMaterialDto rewardGiftMaterialDto) {
    this.createValidation(rewardGiftMaterialDto);
    RewardGiftMaterial rewardGiftMaterial = this.nebulaToolkitService.copyObjectByWhiteList(rewardGiftMaterialDto, RewardGiftMaterial.class, null, null);
    String loginAccountName = this.loginUserService.getLoginAccountName();
    Date date = new Date();
    rewardGiftMaterial.setModifyAccount(loginAccountName);
    rewardGiftMaterial.setModifyTime(date);
    rewardGiftMaterial.setCreateAccount(loginAccountName);
    rewardGiftMaterial.setCreateTime(date);
    this.rewardGiftMaterialRepository.save(rewardGiftMaterial);
  }

  /**
   * 修改赠品物料信息
   * @param rewardGiftMaterialDto
   */
  @Override
  @Transactional
  public void update(RewardGiftMaterialDto rewardGiftMaterialDto) {
    this.updateValidation(rewardGiftMaterialDto);
    RewardGiftMaterial rewardGiftMaterial = this.nebulaToolkitService.copyObjectByWhiteList(rewardGiftMaterialDto, RewardGiftMaterial.class, null, null);
    rewardGiftMaterial.setModifyAccount(this.loginUserService.getLoginAccountName());
    rewardGiftMaterial.setModifyTime(new Date());
    this.rewardGiftMaterialRepository.updateById(rewardGiftMaterial);
  }

  /**
   * 修改验证
   * @param rewardGiftMaterialDto
   */
  private void updateValidation(RewardGiftMaterialDto rewardGiftMaterialDto) {
    Validate.notNull(rewardGiftMaterialDto, "进行此操作时，入参对象不能为空！");
    Validate.notNull(rewardGiftMaterialDto.getId(), "进行修改操作时，主键id不能为空");
    Validate.notNull(rewardGiftMaterialDto.getRewardGiftId(), "进行修改操作时，主键赠品id不能为空");
    Validate.notNull(rewardGiftMaterialDto.getMaterialCode(), "进行修改操作时，主键物料编码不能为空");
//    Validate.notNull(rewardGiftMaterialDto.getMaterialName(), "进行修改操作时，主键物料名称不能为空");
  }

  /**
   * 新增验证
   * @param rewardGiftMaterialDto
   */
  private void createValidation(RewardGiftMaterialDto rewardGiftMaterialDto) {
    Validate.notNull(rewardGiftMaterialDto, "进行此操作时，入参对象不能为空！");
    rewardGiftMaterialDto.setId(null);
    Validate.notNull(rewardGiftMaterialDto.getRewardGiftId(), "进行新增操作时，主键赠品id不能为空");
    Validate.notNull(rewardGiftMaterialDto.getMaterialCode(), "进行新增操作时，主键物料编码不能为空");
//    Validate.notNull(rewardGiftMaterialDto.getMaterialName(), "进行新增操作时，主键物料名称不能为空");
  }
}
