package com.biz.crm.cps.business.reward.gift.local.service.internal;

import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.cps.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.cps.business.reward.gift.local.entity.RewardGift;
import com.biz.crm.cps.business.reward.gift.local.repository.RewardGiftRepository;
import com.biz.crm.cps.business.reward.gift.local.service.RewardGiftService;
import com.biz.crm.cps.business.reward.gift.sdk.dto.RewardGiftDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;

/**
 * 奖励赠品接口实现
 * @author songjingen
 */
@Service
public class RewardGiftServiceImpl implements RewardGiftService {

  @Autowired
  private RewardGiftRepository rewardGiftRepository;

  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;

  @Autowired(required = false)
  private LoginUserService loginUserService;

  /**
   * 根据参与者类型和参与者编码查询赠品信息
   * @param participatorCode
   * @param participatorType
   * @return
   */
  @Override
  public RewardGift findByParticipatorCodeAndParticipatorType(String participatorCode, String participatorType) {
    if (StringUtils.isBlank(participatorCode) || StringUtils.isBlank(participatorType)) {
      return null;
    }
    return this.rewardGiftRepository.findByParticipatorCodeAndParticipatorType(participatorCode, participatorType);
  }

  /**
   * 创建赠品信息
   * @param rewardGiftDto
   * @return
   */
  @Transactional
  @Override
  public RewardGift create(RewardGiftDto rewardGiftDto) {
    this.createValidation(rewardGiftDto);
    RewardGift rewardGift = this.nebulaToolkitService.copyObjectByWhiteList(rewardGiftDto, RewardGift.class, null, null);
    String loginAccountName = this.loginUserService.getLoginAccountName();
    Date date = new Date();
    rewardGift.setModifyAccount(loginAccountName);
    rewardGift.setModifyTime(date);
    rewardGift.setCreateAccount(loginAccountName);
    rewardGift.setCreateTime(date);
    rewardGift.setTenantCode(TenantUtils.getTenantCode());
    rewardGift.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
    rewardGift.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    this.rewardGiftRepository.save(rewardGift);
    return rewardGift;
  }

  /**
   * 新增验证
   * @param rewardGiftDto
   */
  private void createValidation(RewardGiftDto rewardGiftDto) {
    Validate.notNull(rewardGiftDto, "进行此操作时，入参对象不能为空！");
    Validate.notBlank(rewardGiftDto.getParticipatorType(), "参与者类型不能为空;");
    Validate.notBlank(rewardGiftDto.getParticipatorCode(), "参与者编码不能为空;");
    Validate.notBlank(rewardGiftDto.getParticipatorName(), "参与者名称不能为空;");
  }
}
