package com.biz.crm.cps.business.reward.gift.local.service.notifier;

import com.biz.crm.cps.business.reward.gift.local.service.RewardGiftDetailService;
import com.biz.crm.cps.business.reward.gift.sdk.dto.RewardGiftDetailDto;
import com.biz.crm.cps.business.reward.gift.sdk.vo.RewardGiftDetailVo;
import com.biz.crm.cps.business.reward.sdk.common.enums.IncomeStatusEnum;
import com.biz.crm.cps.business.reward.sdk.dto.RewardConditionDto;
import com.biz.crm.cps.business.reward.sdk.service.observer.RewardMountRegister;
import com.biz.crm.cps.business.reward.sdk.service.observer.RewardServiceObserver;
import com.biz.crm.cps.business.reward.sdk.service.strategy.RewardComputeStrategy;
import com.biz.crm.cps.business.reward.sdk.service.strategy.RewardComputeStrategyHolder;
import com.biz.crm.cps.business.reward.sdk.vo.ComputeCashVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import jodd.util.StringUtil;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;

/**
 * @author songjingen
 * 实现奖励模块定义的观察者，进行生成赠品流水记录
 */
@Component
public class GiftRewardServiceObserverImpl implements RewardServiceObserver {

  @Autowired
  @Qualifier("GiftRewardMountRegisterServiceImpl")
  private RewardMountRegister rewardMountRegister;

  @Autowired
  private NebulaToolkitService nebulaToolkitService;

  @Autowired(required = false)
  private RewardComputeStrategyHolder rewardComputeStrategyHolder;

  @Autowired
  private RewardGiftDetailService rewardGiftDetailService;

  /**
   * 创建奖励赠品流水
   * @param item
   */
  @Override
  @Transactional
  public void onCreate(RewardConditionDto item) {
    Validate.notNull(item, "奖励条件信息不能为空！");
    Validate.notBlank(item.getRewardMethodFlag(), "奖励方式不能为空！");
    Validate.notBlank(item.getAwardConditionFlag(), "奖励计算方式不能为空！");
    // 1根据奖励方式判断是否计算
    if (StringUtil.equals(item.getRewardMethodFlag(), rewardMountRegister.getKey())) {
      RewardGiftDetailVo rewardGiftDetailVo = this.nebulaToolkitService.copyObjectByWhiteList(item, RewardGiftDetailVo.class, HashSet.class, ArrayList.class);
      //2根据计算方式选择策略
      Validate.notNull(rewardComputeStrategyHolder, "奖励计算策略控制器不能为空！");
      RewardComputeStrategy computeStrategy = this.rewardComputeStrategyHolder.getStrategy(item.getAwardConditionFlag());
      Validate.notNull(computeStrategy, "赠品奖励计算方式不能为空！");
      ComputeCashVo computeCashVo = computeStrategy.calculate(item);
      BigDecimal amount = computeCashVo.getRecordCash() == null ? BigDecimal.ZERO : computeCashVo.getRecordCash();
      rewardGiftDetailVo.setAmount(amount);
      //3根据条件计算结果，保存流水
      rewardGiftDetailVo.setParticipatorCode(item.getAdditionalParticipatorCode());
      rewardGiftDetailVo.setParticipatorName(item.getAdditionalParticipatorName());
      rewardGiftDetailVo.setParticipatorType(item.getAdditionalParticipatorFlag());
      rewardGiftDetailVo.setOrgCode(item.getOrgCode());
      rewardGiftDetailVo.setOrgName(item.getOrgName());
      rewardGiftDetailVo.setChannel(item.getChannel());
      rewardGiftDetailVo.setPhone(item.getPhone());
      rewardGiftDetailVo.setMaterialCode(item.getGiftCode());
      // redPacketDetailVo对象转RedPacketDetailDto对象
      RewardGiftDetailDto rewardGiftDetailDto = this.nebulaToolkitService.copyObjectByWhiteList(rewardGiftDetailVo, RewardGiftDetailDto.class, HashSet.class, ArrayList.class);
      rewardGiftDetailDto.setType(IncomeStatusEnum.ADD.getDictCode());
      //4判断是否有传递奖励
      this.rewardGiftDetailService.create(rewardGiftDetailDto);
    }
  }
}
