/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.reward.gift.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.LoginUserDetailsForCPS;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.cps.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.cps.business.consumer.sdk.service.ConsumerVoService;
import com.biz.crm.cps.business.consumer.sdk.vo.ConsumerVo;
import com.biz.crm.cps.business.participator.sdk.common.enums.ParticipatorTypeEnum;
import com.biz.crm.cps.business.reward.gift.local.config.RewardGiftConfig;
import com.biz.crm.cps.business.reward.gift.local.entity.RewardGift;
import com.biz.crm.cps.business.reward.gift.local.entity.RewardGiftDetail;
import com.biz.crm.cps.business.reward.gift.local.entity.RewardGiftMaterial;
import com.biz.crm.cps.business.reward.gift.local.repository.RewardGiftDetailRepository;
import com.biz.crm.cps.business.reward.gift.local.service.RewardGiftDetailService;
import com.biz.crm.cps.business.reward.gift.local.service.RewardGiftMaterialService;
import com.biz.crm.cps.business.reward.gift.local.service.RewardGiftService;
import com.biz.crm.cps.business.reward.gift.sdk.dto.ActivityDto;
import com.biz.crm.cps.business.reward.gift.sdk.dto.RewardGiftDetailDto;
import com.biz.crm.cps.business.reward.gift.sdk.dto.RewardGiftDto;
import com.biz.crm.cps.business.reward.gift.sdk.dto.RewardGiftMaterialDto;
import com.biz.crm.cps.business.reward.gift.sdk.event.RewardGiftDetailEventListener;
import com.biz.crm.cps.business.reward.gift.sdk.vo.RewardGiftDetailVo;
import com.biz.crm.cps.business.reward.sdk.common.enums.IncomeStatusEnum;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.web.client.RestTemplate;

@Service
public class RewardGiftDetailServiceImpl
implements RewardGiftDetailService {
    private static final Logger log = LoggerFactory.getLogger(RewardGiftDetailServiceImpl.class);
    @Autowired
    private RewardGiftDetailRepository rewardGiftDetailRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private RewardGiftService rewardGiftService;
    @Autowired
    private RewardGiftMaterialService rewardGiftMaterialService;
    @Autowired
    private LoginUserService loginUserService;
    @Autowired
    private GenerateCodeService generateCodeService;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private RewardGiftConfig rewardGiftConfig;
    @Autowired
    private ConsumerVoService consumerVoService;
    @Autowired(required=false)
    private List<RewardGiftDetailEventListener> rewardGiftDetailEventListeners;

    @Override
    @Transactional
    public void create(RewardGiftDetailDto rewardGiftDetailDto) {
        Validate.notNull((Object)rewardGiftDetailDto, (String)"\u8fdb\u884c\u6b64\u64cd\u4f5c\u65f6\uff0c\u65b0\u589e\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        RewardGiftDetail rewardGiftDetail = (RewardGiftDetail)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)rewardGiftDetailDto, RewardGiftDetail.class, null, null, new String[0]));
        RewardGift rewardGift = this.rewardGiftService.findByParticipatorCodeAndParticipatorType(rewardGiftDetail.getParticipatorCode(), rewardGiftDetail.getParticipatorType());
        this.createOrUpdateRewardGift(rewardGift, rewardGiftDetail);
        this.buildRewardGiftDetail(rewardGiftDetail);
        this.rewardGiftDetailRepository.save((Object)rewardGiftDetail);
        if (!CollectionUtils.isEmpty(this.rewardGiftDetailEventListeners)) {
            RewardGiftDetailVo rewardGiftDetailVo = (RewardGiftDetailVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)rewardGiftDetailDto, RewardGiftDetailVo.class, null, null, new String[0]);
            this.rewardGiftDetailEventListeners.forEach(rewardGiftDetailEventListener -> rewardGiftDetailEventListener.onRequestCreateSignTaskActivity(rewardGiftDetailVo));
        }
    }

    @Override
    public Page<RewardGiftDetail> findByConditions(Pageable pageable, RewardGiftDetailDto dto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (dto == null) {
            dto = new RewardGiftDetailDto();
        }
        return this.rewardGiftDetailRepository.findByConditions(pageable, dto);
    }

    @Override
    @Transactional
    public RewardGiftDetail updateTypeByActivityAndParticipatorAndProduct(ActivityDto dto) {
        Validate.notNull((Object)dto, (String)"\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getActivityCode(), (String)"\u6d3b\u52a8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getParticipatorCode(), (String)"\u53c2\u4e0e\u8005\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getProductCode(), (String)"\u5956\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        LoginUserDetailsForCPS loginUser = (LoginUserDetailsForCPS)this.loginUserService.getLoginDetails(LoginUserDetailsForCPS.class);
        if (loginUser.getUsertype().equals(ParticipatorTypeEnum.CONSUMER.getKey())) {
            ConsumerVo consumerVo = this.consumerVoService.findByExternalId(dto.getParticipatorCode());
            if (consumerVo == null) {
                return null;
            }
            dto.setParticipatorCode(consumerVo.getConsumerCode());
        }
        RewardGiftDetail detail = this.rewardGiftDetailRepository.findByActivityAndParticipatorAndProduct(dto);
        detail.setType("3");
        this.rewardGiftDetailRepository.updateById((Object)detail);
        try {
            if (this.rewardGiftConfig != null) {
                String s = (String)this.restTemplate.postForObject(this.rewardGiftConfig.getNotifyUrl(), (Object)detail, String.class, new Object[0]);
                log.info("\u8c03\u7528\u5b9e\u7269\u56de\u8c03\u63a5\u53e3\u65f6\uff0c\u8fd4\u56de\u4fe1\u606f\uff0c{}\uff01", (Object)s);
            }
        }
        catch (RuntimeException e) {
            log.error("\u8c03\u7528\u5b9e\u7269\u56de\u8c03\u63a5\u53e3\u65f6\uff0c\u56de\u8c03\u5916\u90e8\u7cfb\u7edf\u9519\u8bef\uff01");
        }
        return detail;
    }

    private RewardGiftMaterialDto buildRewardGiftMaterialDto(RewardGift rewardGift, RewardGiftDetail rewardGiftDetail) {
        Validate.notNull((Object)((Object)rewardGift), (String)"\u521b\u5efa\u8d60\u54c1\u7269\u6599\u65f6\uff0c\u8d60\u54c1\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)rewardGiftDetail), (String)"\u521b\u5efa\u8d60\u54c1\u7269\u6599\u65f6\uff0c\u8d60\u54c1\u660e\u7ec6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        RewardGiftMaterialDto rewardGiftMaterialDto = new RewardGiftMaterialDto();
        rewardGiftMaterialDto.setRewardGiftId(rewardGift.getId());
        rewardGiftMaterialDto.setMaterialCode(rewardGiftDetail.getMaterialCode());
        rewardGiftMaterialDto.setMaterialName(rewardGiftDetail.getMaterialName());
        rewardGiftMaterialDto.setAmount(rewardGiftDetail.getAmount());
        rewardGiftMaterialDto.setBalance(rewardGiftDetail.getAmount());
        return rewardGiftMaterialDto;
    }

    private RewardGiftDetail buildRewardGiftDetail(RewardGiftDetail rewardGiftDetail) {
        Validate.notNull((Object)((Object)rewardGiftDetail), (String)"\u521b\u5efa\u8d60\u54c1\u7269\u6599\u65f6\uff0c\u8d60\u54c1\u660e\u7ec6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Date date = new Date();
        rewardGiftDetail.setCode((String)this.generateCodeService.generateCode("GIFT-D", 1).get(0));
        rewardGiftDetail.setModifyAccount(this.loginUserService.getLoginAccountName());
        rewardGiftDetail.setModifyTime(date);
        rewardGiftDetail.setCreateAccount(this.loginUserService.getLoginAccountName());
        rewardGiftDetail.setCreateTime(date);
        rewardGiftDetail.setTenantCode(TenantUtils.getTenantCode());
        rewardGiftDetail.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        rewardGiftDetail.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        return rewardGiftDetail;
    }

    private void createOrUpdateRewardGift(RewardGift rewardGift, RewardGiftDetail rewardGiftDetail) {
        if (Objects.nonNull((Object)rewardGift)) {
            rewardGiftDetail.setRewardGiftId(rewardGift.getId());
            this.createOrUpdateRewardGiftMaterial(rewardGift, rewardGiftDetail);
        } else {
            Validate.isTrue((boolean)Objects.equals(IncomeStatusEnum.ADD.getDictCode(), rewardGiftDetail.getType()), (String)"\u8fd8\u672a\u83b7\u53d6\u5230\u8d60\u54c1", (Object[])new Object[0]);
            RewardGiftDto rewardGiftDto = (RewardGiftDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)rewardGiftDetail, RewardGiftDto.class, null, null, new String[0]);
            RewardGift newRewardGift = this.rewardGiftService.create(rewardGiftDto);
            RewardGiftMaterialDto rewardGiftMaterialDto = this.buildRewardGiftMaterialDto(newRewardGift, rewardGiftDetail);
            this.rewardGiftMaterialService.create(rewardGiftMaterialDto);
            rewardGiftDetail.setRewardGiftId(newRewardGift.getId());
        }
    }

    private void createOrUpdateRewardGiftMaterial(RewardGift rewardGift, RewardGiftDetail rewardGiftDetail) {
        List<RewardGiftMaterial> rewardGiftMaterials = this.rewardGiftMaterialService.findByRewardGiftId(rewardGift.getId());
        if (Objects.nonNull(rewardGiftMaterials)) {
            List currentRewardGiftMaterials = rewardGiftMaterials.stream().filter(rewardGiftMaterial -> rewardGiftMaterial.getMaterialCode().equals(rewardGiftDetail.getMaterialCode())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(currentRewardGiftMaterials)) {
                BigDecimal balance;
                RewardGiftMaterial rewardGiftMaterial2 = (RewardGiftMaterial)((Object)currentRewardGiftMaterials.get(0));
                BigDecimal amount = rewardGiftMaterial2.getAmount() == null ? BigDecimal.ZERO : rewardGiftMaterial2.getAmount();
                BigDecimal bigDecimal = balance = rewardGiftMaterial2.getBalance() == null ? BigDecimal.ZERO : rewardGiftMaterial2.getBalance();
                if (Objects.equals(IncomeStatusEnum.ADD.getDictCode(), rewardGiftDetail.getType())) {
                    balance = balance.add(rewardGiftDetail.getAmount()).setScale(4, RoundingMode.HALF_UP);
                    amount = amount.add(rewardGiftDetail.getAmount()).setScale(4, RoundingMode.HALF_UP);
                } else if (Objects.equals(IncomeStatusEnum.SUBTRACT.getDictCode(), rewardGiftDetail.getType())) {
                    Validate.isTrue((balance.compareTo(rewardGiftDetail.getAmount()) >= 0 ? 1 : 0) != 0, (String)"\u51cf\u5c11\u8d60\u54c1\u6570\u91cf\u65f6\uff0c\u51cf\u5c11\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc7\u4f59\u91cf", (Object[])new Object[0]);
                    balance = balance.subtract(rewardGiftDetail.getAmount()).setScale(4, RoundingMode.HALF_UP);
                }
                RewardGiftMaterialDto rewardGiftMaterialDto = (RewardGiftMaterialDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)rewardGiftMaterial2, RewardGiftMaterialDto.class, null, null, new String[0]);
                rewardGiftMaterialDto.setAmount(amount);
                rewardGiftMaterialDto.setBalance(balance);
                this.rewardGiftMaterialService.update(rewardGiftMaterialDto);
                rewardGiftDetail.setBalance(balance);
                rewardGiftDetail.setRewardGiftId(rewardGift.getId());
            } else {
                RewardGiftMaterialDto rewardGiftMaterialDto = this.buildRewardGiftMaterialDto(rewardGift, rewardGiftDetail);
                this.rewardGiftMaterialService.create(rewardGiftMaterialDto);
            }
        } else {
            RewardGiftMaterialDto rewardGiftMaterialDto = this.buildRewardGiftMaterialDto(rewardGift, rewardGiftDetail);
            this.rewardGiftMaterialService.create(rewardGiftMaterialDto);
        }
    }
}

