/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.reward.gift.local.service.internal;

import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.reward.gift.local.entity.RewardGiftMaterial;
import com.biz.crm.cps.business.reward.gift.local.repository.RewardGiftMaterialRepository;
import com.biz.crm.cps.business.reward.gift.local.service.RewardGiftMaterialService;
import com.biz.crm.cps.business.reward.gift.sdk.dto.RewardGiftMaterialDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RewardGiftMaterialServiceImpl
implements RewardGiftMaterialService {
    @Autowired
    private RewardGiftMaterialRepository rewardGiftMaterialRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private LoginUserService loginUserService;

    @Override
    public List<RewardGiftMaterial> findByRewardGiftId(String rewardGiftId) {
        if (StringUtils.isBlank((CharSequence)rewardGiftId)) {
            return null;
        }
        return this.rewardGiftMaterialRepository.findByRewardGiftId(rewardGiftId);
    }

    @Override
    @Transactional
    public void create(RewardGiftMaterialDto rewardGiftMaterialDto) {
        this.createValidation(rewardGiftMaterialDto);
        RewardGiftMaterial rewardGiftMaterial = (RewardGiftMaterial)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)rewardGiftMaterialDto, RewardGiftMaterial.class, null, null, new String[0]));
        String loginAccountName = this.loginUserService.getLoginAccountName();
        Date date = new Date();
        rewardGiftMaterial.setModifyAccount(loginAccountName);
        rewardGiftMaterial.setModifyTime(date);
        rewardGiftMaterial.setCreateAccount(loginAccountName);
        rewardGiftMaterial.setCreateTime(date);
        this.rewardGiftMaterialRepository.save((Object)rewardGiftMaterial);
    }

    @Override
    @Transactional
    public void update(RewardGiftMaterialDto rewardGiftMaterialDto) {
        this.updateValidation(rewardGiftMaterialDto);
        RewardGiftMaterial rewardGiftMaterial = (RewardGiftMaterial)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)rewardGiftMaterialDto, RewardGiftMaterial.class, null, null, new String[0]));
        rewardGiftMaterial.setModifyAccount(this.loginUserService.getLoginAccountName());
        rewardGiftMaterial.setModifyTime(new Date());
        this.rewardGiftMaterialRepository.updateById((Object)rewardGiftMaterial);
    }

    private void updateValidation(RewardGiftMaterialDto rewardGiftMaterialDto) {
        Validate.notNull((Object)rewardGiftMaterialDto, (String)"\u8fdb\u884c\u6b64\u64cd\u4f5c\u65f6\uff0c\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)rewardGiftMaterialDto.getId(), (String)"\u8fdb\u884c\u4fee\u6539\u64cd\u4f5c\u65f6\uff0c\u4e3b\u952eid\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)rewardGiftMaterialDto.getRewardGiftId(), (String)"\u8fdb\u884c\u4fee\u6539\u64cd\u4f5c\u65f6\uff0c\u4e3b\u952e\u8d60\u54c1id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)rewardGiftMaterialDto.getMaterialCode(), (String)"\u8fdb\u884c\u4fee\u6539\u64cd\u4f5c\u65f6\uff0c\u4e3b\u952e\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }

    private void createValidation(RewardGiftMaterialDto rewardGiftMaterialDto) {
        Validate.notNull((Object)rewardGiftMaterialDto, (String)"\u8fdb\u884c\u6b64\u64cd\u4f5c\u65f6\uff0c\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        rewardGiftMaterialDto.setId(null);
        Validate.notNull((Object)rewardGiftMaterialDto.getRewardGiftId(), (String)"\u8fdb\u884c\u65b0\u589e\u64cd\u4f5c\u65f6\uff0c\u4e3b\u952e\u8d60\u54c1id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)rewardGiftMaterialDto.getMaterialCode(), (String)"\u8fdb\u884c\u65b0\u589e\u64cd\u4f5c\u65f6\uff0c\u4e3b\u952e\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }
}

