/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.reward.gift.local.service.internal;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.cps.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.cps.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.cps.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.common.sdk.vo.LoginUserDetails;
import com.biz.crm.cps.business.consumer.sdk.service.ConsumerVoService;
import com.biz.crm.cps.business.consumer.sdk.vo.ConsumerVo;
import com.biz.crm.cps.business.participator.sdk.common.enums.ParticipatorTypeEnum;
import com.biz.crm.cps.business.reward.gift.local.config.RewardGiftConfig;
import com.biz.crm.cps.business.reward.gift.local.entity.RewardGift;
import com.biz.crm.cps.business.reward.gift.local.entity.RewardGiftDetail;
import com.biz.crm.cps.business.reward.gift.local.entity.RewardGiftMaterial;
import com.biz.crm.cps.business.reward.gift.local.entity.RewardGiftSendMedia;
import com.biz.crm.cps.business.reward.gift.local.repository.RewardGiftDetailRepository;
import com.biz.crm.cps.business.reward.gift.local.repository.RewardGiftSendMediaRepository;
import com.biz.crm.cps.business.reward.gift.local.service.RewardGiftDetailService;
import com.biz.crm.cps.business.reward.gift.local.service.RewardGiftMaterialService;
import com.biz.crm.cps.business.reward.gift.local.service.RewardGiftService;
import com.biz.crm.cps.business.reward.gift.sdk.common.enums.RewardGiftSendStatusEnum;
import com.biz.crm.cps.business.reward.gift.sdk.dto.ActivityDto;
import com.biz.crm.cps.business.reward.gift.sdk.dto.RewardGiftDetailDto;
import com.biz.crm.cps.business.reward.gift.sdk.dto.RewardGiftDetailListDto;
import com.biz.crm.cps.business.reward.gift.sdk.dto.RewardGiftDto;
import com.biz.crm.cps.business.reward.gift.sdk.dto.RewardGiftMaterialDto;
import com.biz.crm.cps.business.reward.gift.sdk.dto.RewardGiftSendDto;
import com.biz.crm.cps.business.reward.gift.sdk.dto.RewardReceiveGiftSendDto;
import com.biz.crm.cps.business.reward.gift.sdk.dto.RewardRefuseGiftSendDto;
import com.biz.crm.cps.business.reward.gift.sdk.service.observer.RewardGiftPolicyObserver;
import com.biz.crm.cps.business.reward.gift.sdk.vo.RewardGiftDetailListVo;
import com.biz.crm.cps.business.reward.gift.sdk.vo.TaskVo;
import com.biz.crm.cps.business.reward.sdk.common.enums.IncomeStatusEnum;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.web.client.RestTemplate;

@Service
public class RewardGiftDetailServiceImpl
implements RewardGiftDetailService {
    private static final Logger log = LoggerFactory.getLogger(RewardGiftDetailServiceImpl.class);
    @Autowired
    private RewardGiftDetailRepository rewardGiftDetailRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private RewardGiftService rewardGiftService;
    @Autowired
    private RewardGiftMaterialService rewardGiftMaterialService;
    @Autowired
    private RewardGiftSendMediaRepository rewardGiftSendMediaRepository;
    @Autowired
    private LoginUserService loginUserService;
    @Autowired
    private GenerateCodeService generateCodeService;
    @Autowired
    private List<RewardGiftPolicyObserver> rewardGiftSendObservers;
    @Autowired
    private RewardGiftConfig rewardGiftConfig;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private ConsumerVoService consumerVoService;

    @Override
    @Transactional
    public void create(RewardGiftDetailDto rewardGiftDetailDto) {
        log.info("rewardGiftDetailDto\u5165\u53c2\u4fe1\u606f------\u300b{}", (Object)JSON.toJSONString((Object)rewardGiftDetailDto));
        Validate.notNull((Object)rewardGiftDetailDto, (String)"\u8fdb\u884c\u6b64\u64cd\u4f5c\u65f6\uff0c\u65b0\u589e\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        RewardGiftDetail rewardGiftDetail = (RewardGiftDetail)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)rewardGiftDetailDto, RewardGiftDetail.class, null, null, new String[0]));
        RewardGift rewardGift = this.rewardGiftService.findByParticipatorCodeAndParticipatorType(rewardGiftDetail.getParticipatorCode(), rewardGiftDetail.getParticipatorType());
        log.info("rewardGiftDetail\u4fe1\u606f---11111---\u300b{}", (Object)JSON.toJSONString((Object)rewardGiftDetailDto));
        this.createOrUpdateRewardGift(rewardGift, rewardGiftDetail);
        log.info("rewardGiftDetail\u4fe1\u606f---22222---\u300b{}", (Object)JSON.toJSONString((Object)((Object)rewardGiftDetail)));
        this.buildRewardGiftDetail(rewardGiftDetail);
        log.info("rewardGiftDetail\u4fe1\u606f---33333---\u300b{}", (Object)JSON.toJSONString((Object)((Object)rewardGiftDetail)));
        this.rewardGiftDetailRepository.save((Object)rewardGiftDetail);
    }

    @Override
    public Page<RewardGiftDetail> findByConditions(Pageable pageable, RewardGiftDetailDto dto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (dto == null) {
            dto = new RewardGiftDetailDto();
        }
        return this.rewardGiftDetailRepository.findByConditions(pageable, dto);
    }

    @Override
    public Page<RewardGiftDetailListVo> findRecordByConditions(Pageable pageable, RewardGiftDetailListDto dto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (dto == null) {
            dto = new RewardGiftDetailListDto();
        }
        Page<RewardGiftDetailListVo> result = this.rewardGiftDetailRepository.findRecord(pageable, dto);
        this.handRewardGiftDetailListVo(result);
        return result;
    }

    @Override
    public Page<RewardGiftDetailListVo> findDealerRecordByConditions(Pageable pageable, RewardGiftDetailListDto dto) {
        LoginUserDetails loginUserDetails = this.loginUserService.getLoginUser();
        if (Objects.isNull(loginUserDetails)) {
            throw new IllegalArgumentException("\u672a\u627e\u5230\u767b\u5f55\u4fe1\u606f\uff01");
        }
        dto.setDealerCode(loginUserDetails.getConsumerCode());
        Page<RewardGiftDetailListVo> result = this.rewardGiftDetailRepository.findDealerRecordByConditions(pageable, loginUserDetails.getConsumerCode());
        this.handRewardGiftDetailListVo(result);
        return result;
    }

    @Override
    public Page<RewardGiftDetailListVo> findTerminalRecordByConditions(Pageable pageable, RewardGiftDetailListDto dto) {
        LoginUserDetails loginUserDetails = this.loginUserService.getLoginUser();
        if (Objects.isNull(loginUserDetails)) {
            throw new IllegalArgumentException("\u672a\u627e\u5230\u767b\u5f55\u4fe1\u606f\uff01");
        }
        Page<RewardGiftDetailListVo> result = this.rewardGiftDetailRepository.findTerminalRecordByConditions(pageable, loginUserDetails.getConsumerCode());
        this.handRewardGiftDetailListVo(result);
        return result;
    }

    @Override
    @Transactional
    public boolean dealerRewardGiftSend(RewardGiftSendDto dto) {
        LoginUserDetails loginUserDetails = this.loginUserService.getLoginUser();
        if (Objects.isNull(loginUserDetails)) {
            throw new IllegalArgumentException("\u672a\u627e\u5230\u767b\u5f55\u4fe1\u606f\uff01");
        }
        this.validateSend(dto);
        if (!loginUserDetails.getConsumerCode().equals(dto.getDealerCode())) {
            throw new IllegalArgumentException("\u767b\u5f55\u4fe1\u606f\u4e0e\u53c2\u6570\u4e0d\u4e00\u81f4\uff01");
        }
        RewardGiftDetail rewardGiftDetail = (RewardGiftDetail)((Object)this.rewardGiftDetailRepository.getById((Serializable)((Object)dto.getId())));
        if (Objects.isNull((Object)rewardGiftDetail)) {
            throw new IllegalArgumentException("\u672a\u627e\u5230\u8d44\u6e90\u4fe1\u606f");
        }
        if (!RewardGiftSendStatusEnum.WITE_SEND.getDictCode().equals(rewardGiftDetail.getSendStatus())) {
            throw new IllegalArgumentException("\u8d44\u6e90\u5df2\u53d1\u653e\u6216\u5df2\u62d2\u7edd\u53d1\u653e");
        }
        Date date = new Date();
        rewardGiftDetail.setAddress(dto.getAddress());
        rewardGiftDetail.setDealerSendTime(date);
        rewardGiftDetail.setSendStatus(RewardGiftSendStatusEnum.ALREADY_SEND.getDictCode());
        rewardGiftDetail.setRemark(dto.getRemark());
        rewardGiftDetail.setModifyAccount(loginUserDetails.getAccount());
        rewardGiftDetail.setModifyTime(date);
        this.rewardGiftDetailRepository.saveOrUpdate((Object)rewardGiftDetail);
        this.saveMedia(rewardGiftDetail, dto.getImgs());
        if (!CollectionUtils.isEmpty(this.rewardGiftSendObservers)) {
            for (RewardGiftPolicyObserver observer : this.rewardGiftSendObservers) {
                observer.sendToSfa(rewardGiftDetail.getTriggerObject(), rewardGiftDetail.getAmount(), rewardGiftDetail.getAddress(), dto.getImgs());
            }
        }
        return true;
    }

    @Override
    @Transactional
    public boolean dealerRefuseSend(RewardRefuseGiftSendDto dto) {
        LoginUserDetails loginUserDetails = this.loginUserService.getLoginUser();
        if (Objects.isNull(loginUserDetails)) {
            throw new IllegalArgumentException("\u672a\u627e\u5230\u767b\u5f55\u4fe1\u606f\uff01");
        }
        this.validataRefuseSend(dto);
        if (!loginUserDetails.getConsumerCode().equals(dto.getDealerCode())) {
            throw new IllegalArgumentException("\u767b\u5f55\u4fe1\u606f\u4e0e\u53c2\u6570\u4e0d\u4e00\u81f4\uff01");
        }
        if (StringUtils.isBlank((CharSequence)dto.getRemark())) {
            throw new IllegalArgumentException("\u8bf7\u586b\u5199\u5907\u6ce8\u4fe1\u606f\uff01");
        }
        RewardGiftDetail rewardGiftDetail = (RewardGiftDetail)((Object)this.rewardGiftDetailRepository.getById((Serializable)((Object)dto.getId())));
        if (Objects.isNull((Object)rewardGiftDetail)) {
            throw new IllegalArgumentException("\u672a\u627e\u5230\u8d44\u6e90\u4fe1\u606f");
        }
        if (!RewardGiftSendStatusEnum.WITE_SEND.getDictCode().equals(rewardGiftDetail.getSendStatus())) {
            throw new IllegalArgumentException("\u8d44\u6e90\u5df2\u53d1\u653e\u6216\u5df2\u62d2\u7edd\u53d1\u653e");
        }
        Date date = new Date();
        rewardGiftDetail.setSendStatus(RewardGiftSendStatusEnum.REFUSE_SEND.getDictCode());
        rewardGiftDetail.setRemark(dto.getRemark());
        rewardGiftDetail.setModifyAccount(loginUserDetails.getAccount());
        rewardGiftDetail.setModifyTime(date);
        this.rewardGiftDetailRepository.saveOrUpdate((Object)rewardGiftDetail);
        if (!CollectionUtils.isEmpty((Collection)dto.getImgs())) {
            this.saveMedia(rewardGiftDetail, dto.getImgs());
        }
        return true;
    }

    @Override
    public boolean terminalReceiveSend(RewardReceiveGiftSendDto dto) {
        LoginUserDetails loginUserDetails = this.loginUserService.getLoginUser();
        if (Objects.isNull(loginUserDetails)) {
            throw new IllegalArgumentException("\u672a\u627e\u5230\u767b\u5f55\u4fe1\u606f\uff01");
        }
        this.validataReceiveSend(dto);
        if (!loginUserDetails.getConsumerCode().equals(dto.getTerminalCode())) {
            throw new IllegalArgumentException("\u767b\u5f55\u4fe1\u606f\u4e0e\u53c2\u6570\u4e0d\u4e00\u81f4\uff01");
        }
        RewardGiftDetail rewardGiftDetail = (RewardGiftDetail)((Object)this.rewardGiftDetailRepository.getById((Serializable)((Object)dto.getId())));
        if (Objects.isNull((Object)rewardGiftDetail)) {
            throw new IllegalArgumentException("\u672a\u627e\u5230\u8d44\u6e90\u4fe1\u606f");
        }
        if (!RewardGiftSendStatusEnum.ALREADY_SEND.getDictCode().equals(rewardGiftDetail.getSendStatus())) {
            throw new IllegalArgumentException("\u8d44\u6e90\u4e0d\u53ef\u7b7e\u6536");
        }
        Date date = new Date();
        rewardGiftDetail.setTerminalReceivedTime(date);
        rewardGiftDetail.setModifyTime(date);
        rewardGiftDetail.setModifyAccount(loginUserDetails.getAccount());
        rewardGiftDetail.setSendStatus(RewardGiftSendStatusEnum.RECEICED.getDictCode());
        this.rewardGiftDetailRepository.saveOrUpdate((Object)rewardGiftDetail);
        return true;
    }

    private void validataReceiveSend(RewardReceiveGiftSendDto dto) {
        Validate.notNull((Object)dto, (String)"\u53d1\u653e\u8d44\u6e90\u65f6\uff0c\u53d1\u653e\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getId(), (String)"\u53d1\u653e\u8d44\u6e90\u65f6\uff0c\u8d44\u6e90\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getTerminalCode(), (String)"\u53d1\u653e\u8d44\u6e90\u65f6\uff0c\u7ec8\u7aef\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    private void validataRefuseSend(RewardRefuseGiftSendDto dto) {
        Validate.notNull((Object)dto, (String)"\u62d2\u7edd\u53d1\u653e\u8d44\u6e90\u65f6\uff0c\u53d1\u653e\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getId(), (String)"\u62d2\u7edd\u53d1\u653e\u8d44\u6e90\u65f6\uff0c\u8d44\u6e90\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getDealerCode(), (String)"\u62d2\u7edd\u53d1\u653e\u8d44\u6e90\u65f6\uff0c\u7ecf\u9500\u5546\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    private void validateSend(RewardGiftSendDto dto) {
        Validate.notNull((Object)dto, (String)"\u53d1\u653e\u8d44\u6e90\u65f6\uff0c\u53d1\u653e\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getId(), (String)"\u53d1\u653e\u8d44\u6e90\u65f6\uff0c\u8d44\u6e90\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getDealerCode(), (String)"\u53d1\u653e\u8d44\u6e90\u65f6\uff0c\u7ecf\u9500\u5546\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notEmpty((Collection)dto.getImgs(), (String)"\u53d1\u653e\u8d44\u6e90\u65f6\uff0c\u53d1\u653e\u56fe\u7247\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getAddress(), (String)"\u5b9a\u4f4d\u5931\u8d25\uff01", (Object[])new Object[0]);
    }

    private void saveMedia(RewardGiftDetail rewardGiftDetail, List<String> imgUrls) {
        if (!CollectionUtils.isEmpty(imgUrls)) {
            ArrayList<RewardGiftSendMedia> list = new ArrayList<RewardGiftSendMedia>();
            for (String imgurl : imgUrls) {
                RewardGiftSendMedia media = new RewardGiftSendMedia();
                media.setGift_detail_id(rewardGiftDetail.getId());
                media.setImg_url(imgurl);
                list.add(media);
            }
            this.rewardGiftSendMediaRepository.saveBatch(list);
        }
    }

    private void handRewardGiftDetailListVo(Page<RewardGiftDetailListVo> result) {
        if (!CollectionUtils.isEmpty((Collection)result.getRecords())) {
            for (RewardGiftDetailListVo vo : result.getRecords()) {
                String displayBusinessCode;
                TaskVo taskVo;
                if ("quantifyPolicy".equals(vo.getTriggerAction())) {
                    String quantifyBusinessCode = vo.getTriggerObject();
                    taskVo = this.rewardGiftDetailRepository.findQuantifyGiftNumByBusinessCode(quantifyBusinessCode);
                    if (Objects.nonNull(taskVo)) {
                        vo.setMaterialNum(taskVo.getRewardData());
                        vo.setRewardName(vo.getAgreementName() + taskVo.getTaskName());
                        vo.setDisplayDate(taskVo.getDisplayDate());
                    }
                } else if ("displayPolicy".equals(vo.getTriggerAction()) && Objects.nonNull(taskVo = this.rewardGiftDetailRepository.findDisplayGiftNumByBusinessCode(displayBusinessCode = vo.getTriggerObject()))) {
                    vo.setMaterialNum(taskVo.getRewardData());
                    vo.setRewardName(vo.getAgreementName() + taskVo.getTaskName());
                    vo.setDisplayDate(taskVo.getDisplayDate());
                }
                List<String> imgUrls = this.rewardGiftSendMediaRepository.findByGiftDetailId(vo.getId());
                vo.setImgUrls(imgUrls);
            }
        }
    }

    private RewardGiftMaterialDto buildRewardGiftMaterialDto(RewardGift rewardGift, RewardGiftDetail rewardGiftDetail) {
        Validate.notNull((Object)((Object)rewardGift), (String)"\u521b\u5efa\u8d60\u54c1\u7269\u6599\u65f6\uff0c\u8d60\u54c1\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)rewardGiftDetail), (String)"\u521b\u5efa\u8d60\u54c1\u7269\u6599\u65f6\uff0c\u8d60\u54c1\u660e\u7ec6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        RewardGiftMaterialDto rewardGiftMaterialDto = new RewardGiftMaterialDto();
        rewardGiftMaterialDto.setRewardGiftId(rewardGift.getId());
        rewardGiftMaterialDto.setMaterialCode(rewardGiftDetail.getMaterialCode());
        rewardGiftMaterialDto.setMaterialName(rewardGiftDetail.getMaterialName());
        rewardGiftMaterialDto.setAmount(rewardGiftDetail.getAmount());
        rewardGiftMaterialDto.setBalance(rewardGiftDetail.getAmount());
        return rewardGiftMaterialDto;
    }

    private RewardGiftDetail buildRewardGiftDetail(RewardGiftDetail rewardGiftDetail) {
        Validate.notNull((Object)((Object)rewardGiftDetail), (String)"\u521b\u5efa\u8d60\u54c1\u7269\u6599\u65f6\uff0c\u8d60\u54c1\u660e\u7ec6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Date date = new Date();
        rewardGiftDetail.setCode((String)this.generateCodeService.generateCode("GIFT-D", 1).get(0));
        rewardGiftDetail.setModifyAccount(this.loginUserService.getLoginAccountName());
        rewardGiftDetail.setModifyTime(date);
        rewardGiftDetail.setCreateAccount(this.loginUserService.getLoginAccountName());
        rewardGiftDetail.setCreateTime(date);
        rewardGiftDetail.setTenantCode(TenantUtils.getTenantCode());
        rewardGiftDetail.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        rewardGiftDetail.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        return rewardGiftDetail;
    }

    private void createOrUpdateRewardGift(RewardGift rewardGift, RewardGiftDetail rewardGiftDetail) {
        if (Objects.nonNull((Object)rewardGift)) {
            rewardGiftDetail.setRewardGiftId(rewardGift.getId());
            this.createOrUpdateRewardGiftMaterial(rewardGift, rewardGiftDetail);
        } else {
            Validate.isTrue((boolean)Objects.equals(IncomeStatusEnum.ADD.getDictCode(), rewardGiftDetail.getType()), (String)"\u8fd8\u672a\u83b7\u53d6\u5230\u8d60\u54c1", (Object[])new Object[0]);
            RewardGiftDto rewardGiftDto = (RewardGiftDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)rewardGiftDetail, RewardGiftDto.class, null, null, new String[0]);
            RewardGift newRewardGift = this.rewardGiftService.create(rewardGiftDto);
            RewardGiftMaterialDto rewardGiftMaterialDto = this.buildRewardGiftMaterialDto(newRewardGift, rewardGiftDetail);
            this.rewardGiftMaterialService.create(rewardGiftMaterialDto);
            rewardGiftDetail.setRewardGiftId(newRewardGift.getId());
        }
    }

    private void createOrUpdateRewardGiftMaterial(RewardGift rewardGift, RewardGiftDetail rewardGiftDetail) {
        List<RewardGiftMaterial> rewardGiftMaterials = this.rewardGiftMaterialService.findByRewardGiftId(rewardGift.getId());
        if (Objects.nonNull(rewardGiftMaterials)) {
            List currentRewardGiftMaterials = rewardGiftMaterials.stream().filter(rewardGiftMaterial -> rewardGiftMaterial.getMaterialCode().equals(rewardGiftDetail.getMaterialCode())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(currentRewardGiftMaterials)) {
                BigDecimal balance;
                RewardGiftMaterial rewardGiftMaterial2 = (RewardGiftMaterial)((Object)currentRewardGiftMaterials.get(0));
                BigDecimal amount = rewardGiftMaterial2.getAmount() == null ? BigDecimal.ZERO : rewardGiftMaterial2.getAmount();
                BigDecimal bigDecimal = balance = rewardGiftMaterial2.getBalance() == null ? BigDecimal.ZERO : rewardGiftMaterial2.getBalance();
                if (Objects.equals(IncomeStatusEnum.ADD.getDictCode(), rewardGiftDetail.getType())) {
                    balance = balance.add(rewardGiftDetail.getAmount()).setScale(4, RoundingMode.HALF_UP);
                    amount = amount.add(rewardGiftDetail.getAmount()).setScale(4, RoundingMode.HALF_UP);
                } else if (Objects.equals(IncomeStatusEnum.SUBTRACT.getDictCode(), rewardGiftDetail.getType())) {
                    Validate.isTrue((balance.compareTo(rewardGiftDetail.getAmount()) >= 0 ? 1 : 0) != 0, (String)"\u51cf\u5c11\u8d60\u54c1\u6570\u91cf\u65f6\uff0c\u51cf\u5c11\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc7\u4f59\u91cf", (Object[])new Object[0]);
                    balance = balance.subtract(rewardGiftDetail.getAmount()).setScale(4, RoundingMode.HALF_UP);
                }
                RewardGiftMaterialDto rewardGiftMaterialDto = (RewardGiftMaterialDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)rewardGiftMaterial2, RewardGiftMaterialDto.class, null, null, new String[0]);
                rewardGiftMaterialDto.setAmount(amount);
                rewardGiftMaterialDto.setBalance(balance);
                this.rewardGiftMaterialService.update(rewardGiftMaterialDto);
                rewardGiftDetail.setBalance(balance);
                rewardGiftDetail.setRewardGiftId(rewardGift.getId());
            } else {
                RewardGiftMaterialDto rewardGiftMaterialDto = this.buildRewardGiftMaterialDto(rewardGift, rewardGiftDetail);
                this.rewardGiftMaterialService.create(rewardGiftMaterialDto);
            }
        } else {
            RewardGiftMaterialDto rewardGiftMaterialDto = this.buildRewardGiftMaterialDto(rewardGift, rewardGiftDetail);
            this.rewardGiftMaterialService.create(rewardGiftMaterialDto);
        }
    }

    @Override
    @Transactional
    public RewardGiftDetail updateTypeByActivityAndParticipatorAndProduct(ActivityDto dto) {
        Validate.notNull((Object)dto, (String)"\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getActivityCode(), (String)"\u6d3b\u52a8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getParticipatorCode(), (String)"\u53c2\u4e0e\u8005\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getProductCode(), (String)"\u5956\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        LoginUserDetails loginUser = this.loginUserService.getLoginUser();
        if (loginUser.getUsertype().equals(ParticipatorTypeEnum.CONSUMER.getKey())) {
            ConsumerVo consumerVo = this.consumerVoService.findByExternalId(dto.getParticipatorCode());
            if (consumerVo == null) {
                return null;
            }
            dto.setParticipatorCode(consumerVo.getConsumerCode());
        }
        RewardGiftDetail detail = this.rewardGiftDetailRepository.findByActivityAndParticipatorAndProduct(dto);
        detail.setType("3");
        this.rewardGiftDetailRepository.updateById((Object)detail);
        try {
            if (this.rewardGiftConfig != null) {
                String s = (String)this.restTemplate.postForObject(this.rewardGiftConfig.getNotifyUrl(), (Object)detail, String.class, new Object[0]);
                log.info("\u8c03\u7528\u5b9e\u7269\u56de\u8c03\u63a5\u53e3\u65f6\uff0c\u8fd4\u56de\u4fe1\u606f\uff0c{}\uff01", (Object)s);
            }
        }
        catch (RuntimeException e) {
            log.error("\u8c03\u7528\u5b9e\u7269\u56de\u8c03\u63a5\u53e3\u65f6\uff0c\u56de\u8c03\u5916\u90e8\u7cfb\u7edf\u9519\u8bef\uff01");
        }
        return detail;
    }
}

