/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.reward.gift.local.service.internal;

import com.biz.crm.cps.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.cps.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.cps.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.reward.gift.local.entity.RewardGift;
import com.biz.crm.cps.business.reward.gift.local.repository.RewardGiftRepository;
import com.biz.crm.cps.business.reward.gift.local.service.RewardGiftService;
import com.biz.crm.cps.business.reward.gift.sdk.dto.RewardGiftDto;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RewardGiftServiceImpl
implements RewardGiftService {
    @Autowired
    private RewardGiftRepository rewardGiftRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private LoginUserService loginUserService;

    @Override
    public RewardGift findByParticipatorCodeAndParticipatorType(String participatorCode, String participatorType) {
        if (StringUtils.isBlank((CharSequence)participatorCode) || StringUtils.isBlank((CharSequence)participatorType)) {
            return null;
        }
        return this.rewardGiftRepository.findByParticipatorCodeAndParticipatorType(participatorCode, participatorType);
    }

    @Override
    @Transactional
    public RewardGift create(RewardGiftDto rewardGiftDto) {
        this.createValidation(rewardGiftDto);
        RewardGift rewardGift = (RewardGift)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)rewardGiftDto, RewardGift.class, null, null, new String[0]));
        String loginAccountName = this.loginUserService.getLoginAccountName();
        Date date = new Date();
        rewardGift.setModifyAccount(loginAccountName);
        rewardGift.setModifyTime(date);
        rewardGift.setCreateAccount(loginAccountName);
        rewardGift.setCreateTime(date);
        rewardGift.setTenantCode(TenantUtils.getTenantCode());
        rewardGift.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        rewardGift.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        this.rewardGiftRepository.save((Object)rewardGift);
        return rewardGift;
    }

    private void createValidation(RewardGiftDto rewardGiftDto) {
        Validate.notNull((Object)rewardGiftDto, (String)"\u8fdb\u884c\u6b64\u64cd\u4f5c\u65f6\uff0c\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)rewardGiftDto.getParticipatorType(), (String)"\u53c2\u4e0e\u8005\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a;", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)rewardGiftDto.getParticipatorCode(), (String)"\u53c2\u4e0e\u8005\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a;", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)rewardGiftDto.getParticipatorName(), (String)"\u53c2\u4e0e\u8005\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a;", (Object[])new Object[0]);
    }
}

