package com.biz.crm.cps.business.reward.gift.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 奖励赠品dto
 * @author songjingen
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "RewardGiftDto", description = "奖励赠品dto")
public class RewardGiftDto {
  private static final long serialVersionUID = 8190467636664597283L;

  /**
   * 参与者编码
   */
  @ApiModelProperty("客户编码")
  private String participatorCode;

  /**
   * 参与者名称
   */
  @ApiModelProperty("客户名称")
  private String participatorName;

  /**
   * 参与者类型
   */
  @ApiModelProperty("客户类型")
  private String participatorType;

  /**
   * 渠道
   */
  @ApiModelProperty("渠道")
  private String channel;

  /**
   * 客户标签
   */
  @ApiModelProperty("客户标签")
  private String tag;

  /**
   * 所属组织编码
   */
  @ApiModelProperty("所属组织编码")
  private String orgCode;

  /**
   * 所属组织名称
   */
  @ApiModelProperty("所属组织名称")
  private String orgName;

  /**
   * 联系电话
   */
  @ApiModelProperty("联系电话")
  private String phone;
}
