package com.biz.crm.cps.business.reward.gift.sdk.dto;

import com.biz.crm.business.common.sdk.vo.TenantOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * 奖励赠品物料dto
 * @author songjingen
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "RewardGiftMaterialDto", description = "奖励赠品物料dto")
public class RewardGiftMaterialDto extends TenantOpVo {
  /**
   * 
   */
  private static final long serialVersionUID = -371456518434990287L;
  /**
   * 赠品id
   */
  @ApiModelProperty("赠品id")
  private String rewardGiftId;

  /**
   * 赠品物料编码
   */
  @ApiModelProperty("赠品物料编码")
  private String materialCode;

  /**
   * 赠品物料名称
   */
  @ApiModelProperty("赠品物料名称")
  private String materialName;

  /**
   * 赠品累计数量d
   */
  @ApiModelProperty("赠品累计数量")
  private BigDecimal amount;

  /**
   * 赠品剩余数量
   */
  @ApiModelProperty("赠品剩余数量")
  private BigDecimal balance;

  /**
   * 备注
   */
  @ApiModelProperty("备注")
  private String remark;
}
