package com.biz.crm.cps.business.reward.gift.sdk.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * 奖励赠品流水明细表vo
 *
 * @author songjingen
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "RewardGiftDetailVo", description = "奖励赠品流水明细表vo")
public class RewardGiftDetailVo extends TenantFlagOpVo {

  private static final long serialVersionUID = -5387176716047899897L;

  /**
   * 赠品变动流水编码
   */
  @ApiModelProperty("赠品变动流水编码")
  @TableField(value = "code")
  private String code;

  /**
   * 参与者类型
   */
  @ApiModelProperty("参与者类型")
  @TableField(value = "participator_type")
  private String participatorType;

  /**
   * 参与者编码
   */
  @ApiModelProperty("参与者编码")
  @TableField(value = "participator_code")
  private String participatorCode;

  /**
   * 参与者名称
   */
  @ApiModelProperty("参与者名称")
  @TableField(value = "participator_name")
  private String participatorName;

  /**
   * 手机号
   */
  @ApiModelProperty("手机号")
  @TableField(value = "phone")
  private String phone;

  /**
   *
   * <pre>
   * 1、红包提现；
   * 2、惩罚扣除（可能有）；
   * 3、扫箱码；
   * 4、扫盖内码；
   * 5、扫盒码；
   * 6、包量任务分利；
   * 7、陈列任务分利；
   * 8、支付扫码分利（后续控价涉及）；
   * </pre>
   * 触发动作
   */
  @ApiModelProperty("触发动作")
  @TableField(value = "trigger_action ")
  private String triggerAction;

  /**
   * 触发对象
   */
  @ApiModelProperty("触发对象")
  @TableField(value = "trigger_object")
  private String triggerObject;

  /**
   * 赠品物料编码
   */
  @ApiModelProperty("赠品物料编码")
  @TableField(value = "material_code")
  private String materialCode;

  /**
   * 赠品物料名称
   */
  @ApiModelProperty("赠品物料名称")
  @TableField(value = "material_name")
  private String materialName;

  /**
   * 赠品变动数量
   */
  @ApiModelProperty("赠品变动数量")
  @TableField(value = "amount")
  private BigDecimal amount;

  /**
   * 赠品剩余数量
   */
  @ApiModelProperty("赠品剩余数量")
  @TableField(value = "balance")
  private BigDecimal balance;

  /**
   * 赠品id
   */
  @ApiModelProperty("赠品id")
  @TableField(value = "reward_gift_id")
  private String rewardGiftId;
  /**
   * 协议模版编码
   */
  @ApiModelProperty("协议模版编码")
  @TableField(value = "template_code")
  private String templateCode;

  /**
   * 协议编码
   */
  @ApiModelProperty("协议编码")
  @TableField(value = "agreement_code")
  private String agreementCode;
  /**
   * 触发动作所属政策
   */
  @ApiModelProperty("政策名称")
  @TableField(value = "policy_name")
  private String policyName;
  /**
   * 扫码记录编码
   */
  @ApiModelProperty("扫码记录编码")
  @TableField(value = "record_code")
  private String recordCode;

  /**
   * 操作类型，1：增加 2：减少
   */
  @ApiModelProperty("操作类型，1：增加 2：减少")
  @TableField(value = "type")
  private String type;

  /**
   * 参与者所属机构编码
   */
  @ApiModelProperty("参与者所属机构编码")
  private String orgCode;

  /**
   * 参与者所属机构名称
   */
  @ApiModelProperty("参与者所属机构名称")
  private String orgName;
  /**
   * 参与者所属渠道
   */
  @ApiModelProperty("参与者所属渠道")
  private String channel;

  /**
   * 奖项编码
   */
  @ApiModelProperty("奖项编码")
  private String rewardCode;
}
