/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.reward.integral.local.service.observer;

import com.biz.crm.cps.business.reward.integral.local.service.IntegralDetailService;
import com.biz.crm.cps.business.reward.integral.sdk.dto.IntegralDetailDto;
import com.biz.crm.cps.business.reward.sdk.dto.RewardConditionDto;
import com.biz.crm.cps.business.reward.sdk.service.observer.RewardMountRegister;
import com.biz.crm.cps.business.reward.sdk.service.observer.RewardServiceObserver;
import com.biz.crm.cps.business.reward.sdk.service.strategy.RewardComputeStrategy;
import com.biz.crm.cps.business.reward.sdk.service.strategy.RewardComputeStrategyHolder;
import com.biz.crm.cps.business.reward.sdk.vo.ComputeCashVo;
import com.bizunited.platform.common.service.NebulaToolkitService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import jodd.util.StringUtil;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="IntegralRewardServerObserverImpl")
public class IntegralRewardServerObserverImpl
implements RewardServiceObserver {
    private static final Logger log = LoggerFactory.getLogger(IntegralRewardServerObserverImpl.class);
    @Autowired
    @Qualifier(value="IntegralRewardMountRegisterImpl")
    private RewardMountRegister rewardMountObserver;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private RewardComputeStrategyHolder rewardComputeStrategyHolder;
    @Autowired
    private IntegralDetailService integralDetailService;

    public void onCreate(RewardConditionDto item) {
        Validate.notNull((Object)item, (String)"\u5956\u52b1\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)item.getRewardMethodFlag(), (String)"\u5956\u52b1\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)item.getAwardConditionFlag(), (String)"\u5956\u52b1\u8ba1\u7b97\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        if (StringUtil.equals((String)item.getRewardMethodFlag(), (String)this.rewardMountObserver.getKey())) {
            IntegralDetailDto integralDetailReqVo = (IntegralDetailDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)item, IntegralDetailDto.class, HashSet.class, ArrayList.class, new String[0]);
            Validate.notNull((Object)this.rewardComputeStrategyHolder, (String)"\u5956\u52b1\u8ba1\u7b97\u7b56\u7565\u63a7\u5236\u5668\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            RewardComputeStrategy computeStrategy = this.rewardComputeStrategyHolder.getStrategy(item.getAwardConditionFlag());
            Validate.notNull((Object)computeStrategy, (String)"\u79ef\u5206\u5956\u52b1\u8ba1\u7b97\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            ComputeCashVo calculate = computeStrategy.calculate(item);
            BigDecimal amount = calculate.getRecordCash() == null ? BigDecimal.ZERO : calculate.getRecordCash();
            integralDetailReqVo.setAmount(amount);
            integralDetailReqVo.setParticipatorCode(item.getAdditionalParticipatorCode());
            integralDetailReqVo.setParticipatorName(item.getAdditionalParticipatorName());
            integralDetailReqVo.setParticipatorType(item.getAdditionalParticipatorFlag());
            integralDetailReqVo.setChannel(item.getChannel());
            IntegralDetailDto integralDetailDto = (IntegralDetailDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)integralDetailReqVo, IntegralDetailDto.class, HashSet.class, ArrayList.class, new String[0]);
            this.integralDetailService.create(integralDetailDto);
        }
    }
}

