/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.reward.integral.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.LoginUserDetailsForCPS;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.common.local.model.Result;
import com.biz.crm.cps.business.participator.sdk.common.enums.ParticipatorTypeEnum;
import com.biz.crm.cps.business.reward.integral.sdk.dto.IntegralDetailDto;
import com.biz.crm.cps.business.reward.integral.sdk.service.IntegralDetailRespVoService;
import com.biz.crm.cps.business.reward.integral.sdk.vo.IntegralDetailRespVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u79ef\u5206\u53d8\u52a8\u6d41\u6c34"})
@RequestMapping(value={"/v1/integral/detailResp"})
public class IntegralDetailRespVoController {
    private static final Logger log = LoggerFactory.getLogger(IntegralDetailRespVoController.class);
    @Autowired
    private IntegralDetailRespVoService integralDetailRespVoService;
    @Autowired(required=false)
    private LoginUserService loginUserService;

    @ApiOperation(value="\u79ef\u5206\u6d41\u6c34\u660e\u7ec6\u5217\u8868")
    @GetMapping(value={"/findByConditions"})
    public Result<Page<IntegralDetailRespVo>> findByConditions(@PageableDefault(value=50) Pageable pageable, @ApiParam(name="integralDetailDto", value="\u79ef\u5206\u6d41\u6c34\u8bf7\u6c42vo") IntegralDetailDto dto) {
        try {
            Page integralDetailRespVoPage = this.integralDetailRespVoService.findByConditions(pageable, dto);
            return Result.ok((Object)integralDetailRespVoPage);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5f53\u524d\u7528\u6237\u79ef\u5206\u6d41\u6c34\u660e\u7ec6\u5217\u8868")
    @GetMapping(value={"/findByCurrentUser"})
    public Result<Page<IntegralDetailRespVo>> findByCurrentUser(@PageableDefault(value=50) Pageable pageable, @ApiParam(name="integralDetailDto", value="\u79ef\u5206\u6d41\u6c34\u8bf7\u6c42vo") IntegralDetailDto dto) {
        try {
            LoginUserDetailsForCPS userDetails = (LoginUserDetailsForCPS)this.loginUserService.getLoginDetails(LoginUserDetailsForCPS.class);
            ParticipatorTypeEnum participatorTypeEnum = ParticipatorTypeEnum.getByKey((String)userDetails.getUsertype());
            dto.setParticipatorCode(userDetails.getConsumerCode());
            dto.setParticipatorType(participatorTypeEnum.getDictCode());
            Page integralDetailRespVoPage = this.integralDetailRespVoService.findByConditions(pageable, dto);
            return Result.ok((Object)integralDetailRespVoPage);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u79ef\u5206\u7f16\u8f91--\u79ef\u5206\u660e\u7ec6\u65b0\u589e")
    @PostMapping
    public Result<IntegralDetailRespVo> deduct(@RequestBody @ApiParam(name="integralDetail", value="\u79ef\u5206\u6d41\u6c34\u4fe1\u606f") IntegralDetailDto dto) {
        try {
            LoginUserDetailsForCPS userDetails = (LoginUserDetailsForCPS)this.loginUserService.getLoginDetails(LoginUserDetailsForCPS.class);
            ParticipatorTypeEnum participatorTypeEnum = ParticipatorTypeEnum.getByKey((String)userDetails.getUsertype());
            dto.setParticipatorCode(userDetails.getConsumerCode());
            dto.setParticipatorType(participatorTypeEnum.getDictCode());
            IntegralDetailRespVo integralDetailRespVo = this.integralDetailRespVoService.deduct(dto);
            return Result.ok((Object)integralDetailRespVo);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

