/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.reward.integral.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.agreement.sdk.dto.LoginUserAgreementDto;
import com.biz.crm.cps.business.agreement.sdk.service.AgreementVoService;
import com.biz.crm.cps.business.agreement.sdk.vo.AgreementVo;
import com.biz.crm.cps.business.participator.sdk.common.enums.ParticipatorTypeEnum;
import com.biz.crm.cps.business.participator.sdk.service.ParticipatorTagVoService;
import com.biz.crm.cps.business.participator.sdk.vo.ParticipatorTagVo;
import com.biz.crm.cps.business.reward.integral.local.entity.IntegralDetailEntity;
import com.biz.crm.cps.business.reward.integral.local.repository.IntegralDetailRespVoRepository;
import com.biz.crm.cps.business.reward.integral.local.service.IntegralDetailService;
import com.biz.crm.cps.business.reward.integral.sdk.dto.IntegralDetailDto;
import com.biz.crm.cps.business.reward.integral.sdk.service.IntegralDetailRespVoService;
import com.biz.crm.cps.business.reward.integral.sdk.vo.IntegralDetailRespVo;
import com.biz.crm.cps.external.barcode.sdk.service.ScanCodeVoService;
import com.biz.crm.cps.external.barcode.sdk.vo.ScanCodeVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="IntegralDetailRespVoServiceImpl")
public class IntegralDetailRespVoServiceImpl
implements IntegralDetailRespVoService {
    @Autowired
    private IntegralDetailRespVoRepository integralDetailRespVoRepository;
    @Autowired
    private AgreementVoService agreementVoService;
    @Autowired
    private ScanCodeVoService scanCodeVoService;
    @Autowired
    private IntegralDetailService integralDetailService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private ParticipatorTagVoService participatorTagVoService;

    public Page<IntegralDetailRespVo> findByConditions(Pageable pageable, IntegralDetailDto dto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (dto == null) {
            dto = new IntegralDetailDto();
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page<IntegralDetailRespVo> byConditions = null;
        if (StringUtils.isBlank((CharSequence)dto.getParticipatorType())) {
            byConditions = this.integralDetailRespVoRepository.findByConditions(pageable, dto);
        }
        if (ParticipatorTypeEnum.CONSUMER.getDictCode().equals(dto.getParticipatorType())) {
            byConditions = this.integralDetailRespVoRepository.findConsumerByConditions(pageable, dto);
        }
        if (ParticipatorTypeEnum.TERMINAL.getDictCode().equals(dto.getParticipatorType())) {
            byConditions = this.integralDetailRespVoRepository.findTerminalByConditions(pageable, dto);
        }
        if (ParticipatorTypeEnum.DEALER.getDictCode().equals(dto.getParticipatorType())) {
            byConditions = this.integralDetailRespVoRepository.findDealerByConditions(pageable, dto);
        }
        if (byConditions == null || CollectionUtils.isEmpty((Collection)byConditions.getRecords())) {
            return byConditions;
        }
        List records = byConditions.getRecords();
        List codeList = records.stream().map(IntegralDetailRespVo::getParticipatorCode).collect(Collectors.toList());
        Map<Object, Object> participatorTagMap = new HashMap();
        List participatorTagList = this.participatorTagVoService.findByParticipatorCodes(codeList);
        if (!CollectionUtils.isEmpty((Collection)participatorTagList)) {
            participatorTagMap = participatorTagList.stream().collect(Collectors.groupingBy(ParticipatorTagVo::getParticipatorCode));
        }
        for (IntegralDetailRespVo respVo : records) {
            List agreementVos;
            List tags;
            respVo.setChangeReason(respVo.getTriggerAction());
            if (StringUtils.isBlank((CharSequence)respVo.getTemplateCode()) || StringUtils.isBlank((CharSequence)respVo.getParticipatorCode()) || StringUtils.isBlank((CharSequence)respVo.getParticipatorType())) continue;
            LoginUserAgreementDto loginUserAgreementDto = new LoginUserAgreementDto();
            loginUserAgreementDto.setTemplateCodes((List)Lists.newArrayList((Object[])new String[]{respVo.getTemplateCode()}));
            if (ParticipatorTypeEnum.DEALER.getDictCode().equals(respVo.getParticipatorType())) {
                loginUserAgreementDto.setCustomerCode(respVo.getParticipatorCode());
            }
            if (ParticipatorTypeEnum.TERMINAL.getDictCode().equals(respVo.getParticipatorType())) {
                loginUserAgreementDto.setTerminalCode(respVo.getParticipatorCode());
            }
            if (ParticipatorTypeEnum.CONSUMER.getDictCode().equals(respVo.getParticipatorType())) {
                ScanCodeVo byProductCode = this.scanCodeVoService.findByRecordCode(respVo.getRecordCode());
                if (byProductCode == null) continue;
                if (ParticipatorTypeEnum.DEALER.getDictCode().equals(byProductCode.getParticipatorType())) {
                    loginUserAgreementDto.setCustomerCode(byProductCode.getParticipatorCode());
                }
                if (ParticipatorTypeEnum.TERMINAL.getDictCode().equals(byProductCode.getParticipatorType())) {
                    loginUserAgreementDto.setTerminalCode(byProductCode.getParticipatorCode());
                }
            }
            if (!CollectionUtils.isEmpty((Collection)(tags = (List)participatorTagMap.get(respVo.getParticipatorCode())))) {
                String participatorTag = tags.stream().map(tag -> tag.getTagDescription()).collect(Collectors.joining(";"));
                respVo.setTag(participatorTag);
            }
            if (CollectionUtils.isEmpty((Collection)(agreementVos = this.agreementVoService.findByConditions(loginUserAgreementDto)))) continue;
            respVo.setAgreementName(((AgreementVo)agreementVos.get(0)).getAgreementName());
            respVo.setChangeReason(((AgreementVo)agreementVos.get(0)).getAgreementName());
        }
        return byConditions;
    }

    public IntegralDetailRespVo deduct(IntegralDetailDto dto) {
        Validate.notNull((Object)dto, (String)"\u6263\u51cf\u79ef\u5206\u65f6\uff0c\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        IntegralDetailEntity integralDetailEntity = this.integralDetailService.create(dto);
        Validate.notNull((Object)((Object)integralDetailEntity), (String)"\u6263\u51cf\u79ef\u5206\u65f6\uff0c\u8fd4\u56de\u5bf9\u8c61\u4e3a\u7a7a", (Object[])new Object[0]);
        return (IntegralDetailRespVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)integralDetailEntity, IntegralDetailRespVo.class, null, null, new String[0]);
    }
}

