/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.reward.integral.local.service.internal;

import com.biz.crm.business.common.sdk.model.LoginUserDetailsForCPS;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.cps.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.cps.business.consumer.sdk.service.ConsumerVoService;
import com.biz.crm.cps.business.consumer.sdk.vo.ConsumerVo;
import com.biz.crm.cps.business.participator.sdk.common.enums.ParticipatorTypeEnum;
import com.biz.crm.cps.business.participator.sdk.service.ParticipatorVoService;
import com.biz.crm.cps.business.participator.sdk.vo.ParticipatorVo;
import com.biz.crm.cps.business.reward.integral.local.entity.IntegralDetailEntity;
import com.biz.crm.cps.business.reward.integral.local.entity.IntegralEntity;
import com.biz.crm.cps.business.reward.integral.local.repository.IntegralDetailRepository;
import com.biz.crm.cps.business.reward.integral.local.service.IntegralDetailService;
import com.biz.crm.cps.business.reward.integral.local.service.IntegralService;
import com.biz.crm.cps.business.reward.integral.sdk.dto.IntegralDetailDto;
import com.biz.crm.cps.business.reward.integral.sdk.dto.IntegralDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="integralDetailService")
public class IntegralDetailServiceImpl
implements IntegralDetailService {
    private static final Logger log = LoggerFactory.getLogger(IntegralDetailServiceImpl.class);
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired
    private IntegralService integralService;
    @Autowired
    private IntegralDetailRepository integralDetailRepository;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired
    private RedisMutexService redisMutexService;
    @Autowired
    private ParticipatorVoService participatorVoService;
    @Autowired
    private ConsumerVoService consumerVoService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    public IntegralDetailEntity create(IntegralDetailDto integralDetailDto) {
        Validate.notNull((Object)integralDetailDto, (String)"\u4f20\u5165\u65b0\u589e\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)integralDetailDto.getTriggerAction(), (String)"\u89e6\u53d1\u52a8\u4f5c\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)integralDetailDto.getParticipatorCode(), (String)"\u53c2\u4e0e\u8005\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)integralDetailDto.getParticipatorType(), (String)"\u53c2\u4e0e\u8005\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)integralDetailDto.getAmount(), (String)"\u79ef\u5206\u53d8\u52a8\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((new BigDecimal(integralDetailDto.getAmount().intValue()).compareTo(integralDetailDto.getAmount()) == 0 ? 1 : 0) != 0, (String)"\u79ef\u5206\u53ea\u80fd\u4e3a\u6574\u6570", (Object[])new Object[0]);
        log.debug("\u65b0\u589e\u79ef\u5206\u6d41\u6c34\u4f20\u5165\u53c2\u6570={}", (Object)integralDetailDto);
        this.validateParticipator(integralDetailDto);
        IntegralDetailEntity integralDetailEntity = (IntegralDetailEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)integralDetailDto, IntegralDetailEntity.class, HashSet.class, ArrayList.class, new String[0]));
        this.createForm(integralDetailEntity);
        String tenantCode = TenantUtils.getTenantCode();
        String redisKey = String.format("lock:tenant:intergral:business:%s:%s", tenantCode, integralDetailEntity.getParticipatorCode());
        boolean locked = false;
        try {
            IntegralDto integralDto;
            IntegralEntity old;
            locked = this.redisMutexService.tryLock(redisKey, TimeUnit.SECONDS, 5);
            Validate.isTrue((boolean)locked, (String)"\u521b\u5efa\u79ef\u5206\u6d41\u6c34\u7e41\u5fd9\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01", (Object[])new Object[0]);
            if (StringUtils.isBlank((CharSequence)integralDetailEntity.getRebateType())) {
                if (integralDetailEntity.getAmount().compareTo(BigDecimal.ZERO) > 0) {
                    integralDetailEntity.setRebateType("\u624b\u52a8\u589e\u52a0");
                } else {
                    integralDetailEntity.setRebateType("\u624b\u52a8\u6263\u51cf");
                }
            }
            if ((old = this.integralService.findByParticipatorCode(integralDetailEntity.getParticipatorCode())) != null) {
                integralDto = (IntegralDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)old, IntegralDto.class, HashSet.class, ArrayList.class, new String[0]);
                if (integralDetailEntity.getAmount().compareTo(BigDecimal.ZERO) > 0) {
                    integralDto.setAccruingIntegral(old.getAccruingIntegral().add(integralDetailEntity.getAmount()));
                }
                Validate.isTrue((integralDetailEntity.getAmount().compareTo(BigDecimal.ZERO) >= 0 || old.getBalance().compareTo(BigDecimal.ZERO.subtract(integralDetailEntity.getAmount())) >= 0 ? 1 : 0) != 0, (String)"\u79ef\u5206\u4f59\u989d\u4e0d\u8db3\uff0c\u65e0\u6cd5\u6263\u51cf", (Object[])new Object[0]);
                integralDto.setBalance(old.getBalance().add(integralDetailEntity.getAmount()));
                integralDetailEntity.setBalance(old.getBalance().add(integralDetailEntity.getAmount()));
                integralDto.setPhone(integralDetailEntity.getPhone());
                integralDto.setChannel(integralDetailDto.getChannel());
                integralDto.setOrgCode(integralDetailDto.getOrgCode());
                integralDto.setOrgName(integralDetailDto.getOrgName());
                this.integralService.update(integralDto);
                integralDetailEntity.setIntegralId(old.getId());
            } else {
                integralDto = (IntegralDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)integralDetailEntity, IntegralDto.class, HashSet.class, ArrayList.class, new String[0]);
                Validate.isTrue((integralDetailEntity.getAmount().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u5f53\u524d\u79ef\u5206\u4f59\u989d\u4e3a\u96f6\uff0c\u65e0\u6cd5\u6263\u51cf", (Object[])new Object[0]);
                integralDto.setAccruingIntegral(integralDetailEntity.getAmount());
                integralDto.setBalance(integralDetailEntity.getAmount());
                integralDto.setRemark(null);
                integralDto.setOrgCode(integralDetailDto.getOrgCode());
                integralDto.setOrgName(integralDetailDto.getOrgName());
                integralDto.setChannel(integralDetailDto.getChannel());
                integralDto.setPhone(integralDetailDto.getPhone());
                IntegralEntity integral = this.integralService.create(integralDto);
                integralDetailEntity.setBalance(integralDetailEntity.getAmount());
                integralDetailEntity.setIntegralId(integral.getId());
            }
            integralDetailEntity.setYearAndMonth(DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM"));
            this.integralDetailRepository.saveOrUpdate((Object)integralDetailEntity);
            IntegralDetailEntity integralDetailEntity2 = integralDetailEntity;
            return integralDetailEntity2;
        }
        finally {
            if (locked) {
                this.redisMutexService.unlock(redisKey);
            }
        }
    }

    private void createForm(IntegralDetailEntity integralDetailEntity) {
        if (Objects.nonNull(this.generateCodeService)) {
            integralDetailEntity.setCode((String)this.generateCodeService.generateCode("integral_code", 1).get(0));
        }
        integralDetailEntity.setId(null);
        integralDetailEntity.setTenantCode(TenantUtils.getTenantCode());
        integralDetailEntity.setCreateTime(new Date());
        integralDetailEntity.setCreateAccount(((LoginUserDetailsForCPS)this.loginUserService.getLoginDetails(LoginUserDetailsForCPS.class)).getConsumerName());
        integralDetailEntity.setModifyTime(new Date());
        integralDetailEntity.setModifyAccount(((LoginUserDetailsForCPS)this.loginUserService.getLoginDetails(LoginUserDetailsForCPS.class)).getConsumerName());
        integralDetailEntity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        integralDetailEntity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
    }

    @Override
    public BigDecimal sumByParticipatorCodeAndRecordCodes(String participatorCode, List<String> recordCodes) {
        if (StringUtils.isBlank((CharSequence)participatorCode) || CollectionUtils.isEmpty(recordCodes)) {
            return null;
        }
        return this.integralDetailRepository.sumByParticipatorCodeAndRecordCodes(participatorCode, recordCodes);
    }

    @Override
    public BigDecimal sumByTenantCodeAndTriggerAction(String tenantCode, String triggerAction) {
        if (StringUtils.isBlank((CharSequence)tenantCode) || StringUtils.isBlank((CharSequence)triggerAction)) {
            return null;
        }
        return this.integralDetailRepository.sumByTenantCodeAndTriggerAction(tenantCode, triggerAction);
    }

    private void validateParticipator(IntegralDetailDto dto) {
        if (ParticipatorTypeEnum.CONSUMER.getDictCode().equals(dto.getParticipatorType())) {
            ConsumerVo consumerCode = this.consumerVoService.findByExternalId(dto.getParticipatorCode());
            Validate.notNull((Object)consumerCode, (String)"\u672a\u627e\u5230\u6307\u5b9a\u53c2\u4e0e\u8005", (Object[])new Object[0]);
        } else {
            List list = this.participatorVoService.findByParticipatorTypeAndParticipatorCode(dto.getParticipatorType(), dto.getParticipatorCode());
            Validate.notEmpty((Collection)list, (String)"\u672a\u627e\u5230\u6307\u5b9a\u53c2\u4e0e\u8005", (Object[])new Object[0]);
            ParticipatorVo participatorVo = list.stream().filter(item -> Objects.equals(item.getParticipatorType(), dto.getParticipatorType())).findFirst().orElse(null);
            Validate.notNull((Object)participatorVo, (String)"\u672a\u627e\u5230\u6307\u5b9a\u53c2\u4e0e\u8005\uff01", (Object[])new Object[0]);
            dto.setOrgCode(participatorVo.getOrgCode());
            dto.setOrgName(participatorVo.getOrgName());
            dto.setChannel(participatorVo.getChannel());
            dto.setPhone(participatorVo.getPhone());
            dto.setParticipatorName(participatorVo.getParticipatorName());
        }
    }
}

