/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.reward.integral.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.cps.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.cps.business.participator.sdk.service.ParticipatorTagVoService;
import com.biz.crm.cps.business.participator.sdk.vo.ParticipatorTagVo;
import com.biz.crm.cps.business.reward.integral.local.entity.IntegralEntity;
import com.biz.crm.cps.business.reward.integral.local.repository.IntegralRepository;
import com.biz.crm.cps.business.reward.integral.local.service.IntegralService;
import com.biz.crm.cps.business.reward.integral.sdk.dto.IntegralDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="integralService")
public class IntegralServiceImpl
implements IntegralService {
    private static final Logger log = LoggerFactory.getLogger(IntegralServiceImpl.class);
    @Autowired
    private IntegralRepository integralRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private ParticipatorTagVoService participatorTagVoService;

    @Override
    public Page<IntegralEntity> findByConditions(IntegralDto dto, Pageable pageable) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (dto == null) {
            dto = new IntegralDto();
        }
        this.findByTagLike(dto);
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page<IntegralEntity> integralEntityPage = this.integralRepository.findByConditions(dto, pageable);
        Page page = new Page();
        page.setCurrent(integralEntityPage.getCurrent());
        page.setSize(integralEntityPage.getSize());
        page.setTotal(integralEntityPage.getTotal());
        List records = integralEntityPage.getRecords();
        if (CollectionUtils.isEmpty((Collection)records)) {
            return page;
        }
        List codeList = records.stream().map(IntegralEntity::getParticipatorCode).collect(Collectors.toList());
        Map<Object, Object> participatorTagMap = new HashMap();
        List participatorTagList = this.participatorTagVoService.findByParticipatorCodes(codeList);
        if (!CollectionUtils.isEmpty((Collection)participatorTagList)) {
            participatorTagMap = participatorTagList.stream().collect(Collectors.groupingBy(ParticipatorTagVo::getParticipatorCode));
        }
        for (IntegralEntity entity : records) {
            List tags = (List)participatorTagMap.get(entity.getParticipatorCode());
            if (CollectionUtils.isEmpty((Collection)tags)) continue;
            String participatorTag = tags.stream().map(tag -> tag.getTagDescription()).collect(Collectors.joining(";"));
            entity.setTag(participatorTag);
        }
        return integralEntityPage;
    }

    private void findByTagLike(IntegralDto dto) {
        String tag = dto.getTag();
        if (StringUtils.isBlank((CharSequence)tag)) {
            return;
        }
        List participatorTagVos = this.participatorTagVoService.findByTagDescriptionLike(tag);
        if (CollectionUtils.isEmpty((Collection)participatorTagVos)) {
            return;
        }
        List participatorCodeList = participatorTagVos.stream().map(ParticipatorTagVo::getParticipatorCode).collect(Collectors.toList());
        dto.setParticipatorCodes(participatorCodeList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public IntegralEntity create(IntegralDto dto) {
        log.debug("\u4fdd\u5b58\u79ef\u5206\u4fe1\u606f\u5165\u53c2={}", (Object)dto);
        this.createValidation(dto);
        IntegralEntity integralEntity = (IntegralEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, IntegralEntity.class, HashSet.class, ArrayList.class, new String[0]));
        this.createForm(integralEntity);
        this.integralRepository.saveOrUpdate((Object)integralEntity);
        return integralEntity;
    }

    @Override
    public IntegralEntity findByParticipatorCode(String participatorCode) {
        if (StringUtils.isBlank((CharSequence)participatorCode)) {
            return null;
        }
        return this.integralRepository.findByParticipatorCode(participatorCode);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public IntegralEntity update(IntegralDto dto) {
        this.updateValidation(dto);
        IntegralEntity integralEntity = (IntegralEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, IntegralEntity.class, HashSet.class, ArrayList.class, new String[0]));
        IntegralEntity old = (IntegralEntity)((Object)this.integralRepository.getById((Serializable)((Object)integralEntity.getId())));
        Validate.notNull((Object)((Object)old), (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u539f\u59cb\u6a21\u578b\u5bf9\u8c61\u4fe1", (Object[])new Object[0]);
        BeanUtils.copyProperties((Object)((Object)integralEntity), (Object)((Object)old), (String[])new String[]{"id", "modifyTime", "createAccount", "createTime", "tenantCode"});
        Date now = new Date();
        String account = this.loginUserService.getLoginAccountName();
        old.setModifyAccount(account);
        old.setModifyTime(now);
        this.integralRepository.saveOrUpdate((Object)old);
        return old;
    }

    @Override
    public IntegralEntity findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return (IntegralEntity)((Object)this.integralRepository.getById((Serializable)((Object)id)));
    }

    private void createValidation(IntegralDto dto) {
        Validate.notNull((Object)dto, (String)"\u65b0\u589e\u64cd\u4f5c\u65f6\uff0c\u65b0\u589e\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getParticipatorType(), (String)"\u53c2\u4e0e\u8005\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a;", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getParticipatorCode(), (String)"\u53c2\u4e0e\u8005\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a;", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getParticipatorName(), (String)"\u53c2\u4e0e\u8005\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a;", (Object[])new Object[0]);
        Validate.isTrue((dto.getParticipatorType().length() < 255 ? 1 : 0) != 0, (String)"\u53c2\u4e0e\u8005\u7c7b\u578b\uff0c\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((dto.getParticipatorCode().length() < 255 ? 1 : 0) != 0, (String)"\u53c2\u4e0e\u8005\u7f16\u7801\uff0c\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((dto.getParticipatorName().length() < 255 ? 1 : 0) != 0, (String)"\u53c2\u4e0e\u8005\u540d\u79f0\uff0c\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    private void createForm(IntegralEntity integralEntity) {
        integralEntity.setId(null);
        integralEntity.setTenantCode(TenantUtils.getTenantCode());
        integralEntity.setCreateTime(new Date());
        integralEntity.setCreateAccount(this.loginUserService.getLoginAccountName());
        integralEntity.setModifyTime(new Date());
        integralEntity.setModifyAccount(this.loginUserService.getLoginAccountName());
        integralEntity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        integralEntity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
    }

    private void updateValidation(IntegralDto integralDto) {
        Validate.notNull((Object)integralDto, (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u4fee\u6539\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)integralDto.getId(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0cid\u4e0d\u80fd\u4e3a\u7a7a;", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)integralDto.getParticipatorType(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u53c2\u4e0e\u8005\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a;", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)integralDto.getParticipatorCode(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u53c2\u4e0e\u8005\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a;", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)integralDto.getParticipatorName(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u53c2\u4e0e\u8005\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a;", (Object[])new Object[0]);
        Validate.isTrue((integralDto.getParticipatorType().length() < 255 ? 1 : 0) != 0, (String)"\u53c2\u4e0e\u8005\u7c7b\u578b\uff0c\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((integralDto.getParticipatorCode().length() < 255 ? 1 : 0) != 0, (String)"\u53c2\u4e0e\u8005\u7f16\u7801\uff0c\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((integralDto.getParticipatorName().length() < 255 ? 1 : 0) != 0, (String)"\u53c2\u4e0e\u8005\u540d\u79f0\uff0c\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }
}

