/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.reward.integral.local.service.observer;

import com.biz.crm.cps.business.reward.integral.sdk.service.ParticipatorRewardStatisticsVoService;
import com.biz.crm.cps.business.reward.sdk.service.observer.RewardMountRegister;
import com.biz.crm.cps.business.reward.sdk.service.observer.RewardRelParticipatorServiceObserver;
import com.biz.crm.cps.business.reward.sdk.vo.ParticipatorRewardStatisticsVo;
import com.biz.crm.cps.business.reward.sdk.vo.RewardRelParticipatorItemVo;
import com.biz.crm.cps.business.reward.sdk.vo.RewardTypeStatisticsVo;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="IntegralRewardRelParticipatorServiceObserverImpl")
public class IntegralRewardRelParticipatorServiceObserverImpl
implements RewardRelParticipatorServiceObserver {
    @Autowired
    private ParticipatorRewardStatisticsVoService participatorRewardStatisticsVoService;
    @Autowired
    @Qualifier(value="IntegralRewardMountRegisterImpl")
    private RewardMountRegister rewardMountRegister;

    public List<RewardRelParticipatorItemVo> onRequestRewardRelParticipatorItems(List<String> participatorCodes) {
        if (CollectionUtils.isEmpty(participatorCodes)) {
            return null;
        }
        List result = this.participatorRewardStatisticsVoService.findByParticipatorCodes(participatorCodes);
        if (CollectionUtils.isEmpty((Collection)result)) {
            result = Lists.newArrayList();
        }
        ArrayList list = Lists.newArrayList();
        for (String participatorCode : participatorCodes) {
            RewardTypeStatisticsVo vo = new RewardTypeStatisticsVo();
            ParticipatorRewardStatisticsVo statisticsVo = result.stream().filter(item -> Objects.equals(participatorCode, item.getParticipatorCode())).findFirst().orElse(null);
            vo.setName(this.rewardMountRegister.getName());
            vo.setFlag(this.rewardMountRegister.getFlag());
            vo.setKey(this.rewardMountRegister.getKey());
            BigDecimal amount = statisticsVo == null ? BigDecimal.ZERO : statisticsVo.getAmount();
            BigDecimal balance = statisticsVo == null ? BigDecimal.ZERO : statisticsVo.getBalance();
            vo.setAmount(amount.setScale(2, RoundingMode.HALF_UP));
            vo.setBalance(balance.setScale(2, RoundingMode.HALF_UP));
            vo.setTodayAmount(BigDecimal.ZERO);
            if (Objects.nonNull(statisticsVo)) {
                vo.setTodayAmount(Optional.ofNullable(statisticsVo.getTodayAmount()).orElse(BigDecimal.ZERO).setScale(2, RoundingMode.HALF_UP));
            }
            RewardRelParticipatorItemVo item2 = new RewardRelParticipatorItemVo();
            item2.setParticipatorCode(participatorCode);
            item2.setRewardStatisticsVo(vo);
            list.add(item2);
        }
        return list;
    }
}

