/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.reward.integral.local.service.internal;

import com.biz.crm.base.BusinessException;
import com.biz.crm.cps.business.reward.integral.local.entity.IntegralBalanceEntity;
import com.biz.crm.cps.business.reward.integral.local.repository.IntegralBalanceRepository;
import com.biz.crm.cps.business.reward.integral.local.service.IntegralBalanceService;
import com.bizunited.platform.task.annotations.DynamicTaskService;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Date;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="integralBalanceServiceImpl")
public class IntegralBalanceServiceImpl
implements IntegralBalanceService {
    @Autowired
    private IntegralBalanceRepository integralBalanceRepository;

    @Override
    public IntegralBalanceEntity findBalance() {
        IntegralBalanceEntity balance = this.integralBalanceRepository.sumBalance();
        try {
            Date start = DateUtils.parseDate((String)(DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd") + " 00:00:00"), (String[])new String[]{"yyyy-MM-dd HH:mm:ss"});
            Date end = DateUtils.parseDate((String)(DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd") + " 23:59:59"), (String[])new String[]{"yyyy-MM-dd HH:mm:ss"});
            IntegralBalanceEntity byDate = this.sumByCreateTime(start, end);
            if (byDate != null && balance != null) {
                balance.setResidualIntegral(balance.getResidualIntegral().add(byDate.getResidualIntegral()));
                balance.setCumulativeIntegral(balance.getCumulativeIntegral().add(byDate.getCumulativeIntegral()));
            }
            if (byDate != null && balance == null) {
                return byDate;
            }
            return balance;
        }
        catch (ParseException e) {
            throw new BusinessException("\u65e5\u671f\u65f6\u95f4\u8f6c\u6362\u5931\u8d25");
        }
    }

    @Override
    @DynamicTaskService(cornExpression="1 0 0 * * ?", taskDesc="\u79ef\u5206\u6bcf\u65e5\u7edf\u8ba1-\u8ba1\u7b97\u524d\u4e00\u5929\u7684\u6570\u636e")
    public IntegralBalanceEntity create() {
        Date date = DateUtils.addDays((Date)new Date(), (int)-1);
        IntegralBalanceEntity integralBalance = this.findByIntegralDate(date, date);
        if (integralBalance != null) {
            return integralBalance;
        }
        try {
            Date start = DateUtils.parseDate((String)(DateFormatUtils.format((Date)date, (String)"yyyy-MM-dd") + " 00:00:00"), (String[])new String[]{"yyyy-MM-dd HH:mm:ss"});
            Date end = DateUtils.parseDate((String)(DateFormatUtils.format((Date)date, (String)"yyyy-MM-dd") + " 23:59:59"), (String[])new String[]{"yyyy-MM-dd HH:mm:ss"});
            IntegralBalanceEntity byDate = this.sumByCreateTime(start, end);
            if (byDate == null) {
                byDate = new IntegralBalanceEntity();
                byDate.setCumulativeIntegral(BigDecimal.ZERO);
                byDate.setResidualIntegral(BigDecimal.ZERO);
            }
            byDate.setIntegralDate(date);
            this.integralBalanceRepository.save((Object)byDate);
            return byDate;
        }
        catch (ParseException e) {
            throw new BusinessException("\u65e5\u671f\u65f6\u95f4\u8f6c\u6362\u5931\u8d25");
        }
    }

    @Override
    public IntegralBalanceEntity sumByCreateTime(Date dateStart, Date dateEnd) {
        if (dateStart == null || dateEnd == null) {
            return null;
        }
        return this.integralBalanceRepository.sumByCreateTime(dateStart, dateEnd);
    }

    @Override
    public IntegralBalanceEntity findByIntegralDate(Date dateStart, Date dateEnd) {
        if (dateStart == null || dateEnd == null) {
            return null;
        }
        return this.integralBalanceRepository.findByIntegralDate(dateStart, dateEnd);
    }
}

