/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.reward.integral.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.agreement.sdk.dto.LoginUserAgreementDto;
import com.biz.crm.cps.business.agreement.sdk.service.AgreementVoService;
import com.biz.crm.cps.business.agreement.sdk.vo.AgreementVo;
import com.biz.crm.cps.business.participator.sdk.common.enums.ParticipatorTypeEnum;
import com.biz.crm.cps.business.reward.integral.local.repository.IntegralDetailRespVoRepository;
import com.biz.crm.cps.business.reward.integral.sdk.dto.IntegralDetailDto;
import com.biz.crm.cps.business.reward.integral.sdk.service.IntegralDetailRespVoService;
import com.biz.crm.cps.business.reward.integral.sdk.vo.IntegralDetailRespVo;
import com.biz.crm.cps.external.barcode.sdk.service.ScanCodeVoService;
import com.biz.crm.cps.external.barcode.sdk.vo.ScanCodeVo;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="IntegralDetailRespVoServiceImpl")
public class IntegralDetailRespVoServiceImpl
implements IntegralDetailRespVoService {
    @Autowired
    private IntegralDetailRespVoRepository integralDetailRespVoRepository;
    @Autowired
    private AgreementVoService agreementVoService;
    @Autowired
    private ScanCodeVoService scanCodeVoService;

    public Page<IntegralDetailRespVo> findByConditions(Pageable pageable, IntegralDetailDto dto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (dto == null) {
            dto = new IntegralDetailDto();
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page<IntegralDetailRespVo> byConditions = this.integralDetailRespVoRepository.findByConditions(pageable, dto);
        if (byConditions == null || CollectionUtils.isEmpty((Collection)byConditions.getRecords())) {
            return byConditions;
        }
        for (IntegralDetailRespVo respVo : byConditions.getRecords()) {
            List agreementVos;
            respVo.setChangeReason(respVo.getTriggerAction());
            if (StringUtils.isBlank((CharSequence)respVo.getTemplateCode()) || StringUtils.isBlank((CharSequence)respVo.getParticipatorCode()) || StringUtils.isBlank((CharSequence)respVo.getParticipatorType())) continue;
            LoginUserAgreementDto loginUserAgreementDto = new LoginUserAgreementDto();
            loginUserAgreementDto.setTemplateCodes((List)Lists.newArrayList((Object[])new String[]{respVo.getTemplateCode()}));
            if (ParticipatorTypeEnum.DEALER.getDictCode().equals(respVo.getParticipatorType())) {
                loginUserAgreementDto.setCustomerCode(respVo.getParticipatorCode());
            }
            if (ParticipatorTypeEnum.TERMINAL.getDictCode().equals(respVo.getParticipatorType())) {
                loginUserAgreementDto.setTerminalCode(respVo.getParticipatorCode());
            }
            if (ParticipatorTypeEnum.CONSUMER.getDictCode().equals(respVo.getParticipatorType())) {
                ScanCodeVo byProductCode = this.scanCodeVoService.findByProductCode(respVo.getTriggerAction());
                if (byProductCode == null) continue;
                if (ParticipatorTypeEnum.DEALER.getDictCode().equals(byProductCode.getParticipatorType())) {
                    loginUserAgreementDto.setCustomerCode(byProductCode.getParticipatorCode());
                }
                if (ParticipatorTypeEnum.TERMINAL.getDictCode().equals(byProductCode.getParticipatorType())) {
                    loginUserAgreementDto.setTerminalCode(byProductCode.getParticipatorCode());
                }
            }
            if (CollectionUtils.isEmpty((Collection)(agreementVos = this.agreementVoService.findByConditions(loginUserAgreementDto)))) continue;
            respVo.setAgreementName(((AgreementVo)agreementVos.get(0)).getAgreementName());
            respVo.setChangeReason(((AgreementVo)agreementVos.get(0)).getAgreementName());
        }
        return byConditions;
    }
}

