package com.biz.crm.cps.business.reward.local.controller;

import com.biz.crm.cps.business.common.local.model.Result;
import com.biz.crm.cps.business.reward.sdk.service.RewardMountVoService;
import com.biz.crm.cps.business.reward.sdk.vo.RewardMountVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 奖励模块的挂载信息
 * @author yangfan
 */
@Api(tags = "分利协议政策挂载信息")
@Slf4j
@RestController
@RequestMapping("/v1/reward/mount")
public class RewardMountVoController {

  @Autowired
  private RewardMountVoService rewardMountVoService;

  /**
   * 查询系统中存在的奖励模块信息
   */
  @ApiOperation(value = "查询系统中存在的奖励模块信息")
  @GetMapping(value = "/findReward")
  public Result<List<RewardMountVo>> findReward() {
    try {
      List<RewardMountVo> current = this.rewardMountVoService.findReward();
      return Result.ok(current);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
