package com.biz.crm.cps.business.reward.local.service.internal;

import com.biz.crm.cps.business.activity.actual.sdk.event.RandomQuotaComputeEventListener;
import com.biz.crm.cps.business.activity.sdk.dto.ActivityRandomDto;
import com.biz.crm.cps.business.reward.sdk.dto.CashRandomDto;
import com.biz.crm.cps.business.reward.sdk.service.RandomQuotaComputeService;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * 随机中奖事件实现
 * @Author: zengxingwang
 * @Date: 2021/10/26 17:52
 */
@Component
public class RandomQuotaComputeEventListenerImpl implements RandomQuotaComputeEventListener {

  @Autowired
  private RandomQuotaComputeService randomQuotaComputeService;

  /**
   * 随机中奖
   * @param params
   * @return
   */
  @Override
  public BigDecimal onExecute(List<ActivityRandomDto> params) {
    Validate.notEmpty(params, "数据不能为空");
    List<CashRandomDto> list = new ArrayList<>();
    for(ActivityRandomDto param : params){
      CashRandomDto dto = new CashRandomDto();
      dto.setPercent(param.getPercent());
      dto.setCash(param.getCash());
      list.add(dto);
    }
    return randomQuotaComputeService.execute(list);
  }
}
