package com.biz.crm.cps.business.reward.local.service.internal;

import com.biz.crm.cps.business.reward.sdk.dto.CashRandomDto;
import com.biz.crm.cps.business.reward.sdk.service.RandomQuotaComputeService;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

/**
 * @author hecheng
 * @description: 定额随机计算
 * @date 2021/8/17 上午9:54
 */
@Slf4j
@Component("RandomQuotaComputeServiceImpl")
@ConditionalOnMissingBean(name = "RandomQuotaComputeServiceExpandImpl")
public class RandomQuotaComputeServiceImpl implements RandomQuotaComputeService {

  @Override
  public BigDecimal execute(List<CashRandomDto> params) {
    AtomicReference<BigDecimal> returnCash = new AtomicReference<>(BigDecimal.ZERO);
    if (CollectionUtils.isNotEmpty(params)) {
      BigDecimal totalWeight = params.stream().map(CashRandomDto::getPercent)
              .reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP);
      BigDecimal randomNum = new BigDecimal(Math.random() * totalWeight.floatValue());

      // 精确到两位小数
      BigDecimal exactRandomNum = randomNum.setScale(2, BigDecimal.ROUND_DOWN);
      AtomicReference<BigDecimal> atomicRandomNum = new AtomicReference<>(exactRandomNum);
      int num = 0;
      for (CashRandomDto randomVo : params) {
        // 将入参的百分比精确到两位数
        BigDecimal percent =randomVo.getPercent() == null ? BigDecimal.ZERO : randomVo.getPercent();
        BigDecimal exactPercent = percent.setScale(2, BigDecimal.ROUND_DOWN);
        BigDecimal subtract = atomicRandomNum.get().subtract(exactPercent);
        num = subtract.compareTo(BigDecimal.ZERO);
        if (num > 0) {
          atomicRandomNum.set(subtract);
        } else {
          returnCash.set(randomVo.getCash());
          break;
        }
      }
      if (num > 0) {
        CashRandomDto minCash = params.stream().sorted(Comparator.comparing(CashRandomDto::getCash))
                .findFirst().get();
        return minCash.getCash();
      }
    }
    return returnCash.get();
  }
}
