package com.biz.crm.cps.business.reward.local.service.strategy;

import com.biz.crm.cps.business.reward.sdk.dto.RewardConditionDto;
import com.biz.crm.cps.business.reward.sdk.service.observer.ComputeTypeMountRegister;
import com.biz.crm.cps.business.reward.sdk.service.strategy.RewardComputeStrategy;
import com.biz.crm.cps.business.reward.sdk.vo.ComputeCashVo;
import java.math.BigDecimal;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

/**
 * @author hecheng
 * @description: 固定额度计算
 * @date 2021/8/16 下午4:10
 */
@Component("FixedAmountComputeStrategyImpl")
public class FixedAmountComputeStrategyImpl implements RewardComputeStrategy {

  @Autowired
  @Qualifier("FixedAmountComputeTypeMountRegisterServiceImpl")
  private ComputeTypeMountRegister computeTypeMountRegister;

  @Override
  public String getKey() {
    return this.computeTypeMountRegister.getKey();
  }

  @Override
  public ComputeCashVo calculate(RewardConditionDto dto) {
    Validate.notNull(dto.getRewardData(), "奖励计算条件不能为空!");
    Validate.notBlank(dto.getRewardData(), "奖励值不能为空!");
    ComputeCashVo computeCashVo = new ComputeCashVo();
    computeCashVo.setRecordType(dto.getAwardConditionFlag());
    BigDecimal recordCash = new BigDecimal(dto.getRewardData()).setScale(4, BigDecimal.ROUND_UP);
    computeCashVo.setRecordCash(recordCash);
    return computeCashVo;
  }
}
